/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.editor.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for editing documents of all supportable Presentation (PowerPoint-compatible) formats")
public class PresentationLoadOptions
extends LoadOptions {
    @SerializedName(value="slideNumber")
    private Integer slideNumber = null;
    @SerializedName(value="showHiddenSlides")
    private Boolean showHiddenSlides = null;

    public PresentationLoadOptions slideNumber(Integer slideNumber) {
        this.slideNumber = slideNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify the slide number, which should be opened for editing")
    public Integer getSlideNumber() {
        return this.slideNumber;
    }

    public void setSlideNumber(Integer slideNumber) {
        this.slideNumber = slideNumber;
    }

    public PresentationLoadOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether the hidden slides should be included or not. Default is false     - hidden slides are not shown and exception will be thrown while trying to edit")
    public Boolean getShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentationLoadOptions presentationLoadOptions = (PresentationLoadOptions)o;
        return Objects.equals(this.slideNumber, presentationLoadOptions.slideNumber) && Objects.equals(this.showHiddenSlides, presentationLoadOptions.showHiddenSlides) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.slideNumber, this.showHiddenSlides, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresentationLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    slideNumber: ").append(this.toIndentedString(this.slideNumber)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

