/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.editor.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for editing documents of all supportable Spreadsheet (Excel-compatible) formats")
public class SpreadsheetLoadOptions
extends LoadOptions {
    @SerializedName(value="worksheetIndex")
    private Integer worksheetIndex = null;
    @SerializedName(value="excludeHiddenWorksheets")
    private Boolean excludeHiddenWorksheets = null;

    public SpreadsheetLoadOptions worksheetIndex(Integer worksheetIndex) {
        this.worksheetIndex = worksheetIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify the 0-based index of the worksheet (tab) of the input Spreadsheet document, which should be converted to the HTML.")
    public Integer getWorksheetIndex() {
        return this.worksheetIndex;
    }

    public void setWorksheetIndex(Integer worksheetIndex) {
        this.worksheetIndex = worksheetIndex;
    }

    public SpreadsheetLoadOptions excludeHiddenWorksheets(Boolean excludeHiddenWorksheets) {
        this.excludeHiddenWorksheets = excludeHiddenWorksheets;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to exclude hidden worksheets in the input Spreadsheet document, so they will be totally ignored. Default is false - hidden worksheets are available and processed as normal.")
    public Boolean getExcludeHiddenWorksheets() {
        return this.excludeHiddenWorksheets;
    }

    public void setExcludeHiddenWorksheets(Boolean excludeHiddenWorksheets) {
        this.excludeHiddenWorksheets = excludeHiddenWorksheets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetLoadOptions spreadsheetLoadOptions = (SpreadsheetLoadOptions)o;
        return Objects.equals(this.worksheetIndex, spreadsheetLoadOptions.worksheetIndex) && Objects.equals(this.excludeHiddenWorksheets, spreadsheetLoadOptions.excludeHiddenWorksheets) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.worksheetIndex, this.excludeHiddenWorksheets, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpreadsheetLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    worksheetIndex: ").append(this.toIndentedString(this.worksheetIndex)).append("\n");
        sb.append("    excludeHiddenWorksheets: ").append(this.toIndentedString(this.excludeHiddenWorksheets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

