/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.editor.model.SaveOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for generating and saving Spreadsheet (Excel-compliant) documents")
public class SpreadsheetSaveOptions
extends SaveOptions {
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="protectionType")
    private ProtectionTypeEnum protectionType = null;
    @SerializedName(value="protectionPassword")
    private String protectionPassword = null;

    public SpreadsheetSaveOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Allows to specify document password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SpreadsheetSaveOptions protectionType(ProtectionTypeEnum protectionType) {
        this.protectionType = protectionType;
        return this;
    }

    @ApiModelProperty(required=true, value="Write-protection type. Default value is None.")
    public ProtectionTypeEnum getProtectionType() {
        return this.protectionType;
    }

    public void setProtectionType(ProtectionTypeEnum protectionType) {
        this.protectionType = protectionType;
    }

    public SpreadsheetSaveOptions protectionPassword(String protectionPassword) {
        this.protectionPassword = protectionPassword;
        return this;
    }

    @ApiModelProperty(value="Write-protection password. Used when protection type is specified.")
    public String getProtectionPassword() {
        return this.protectionPassword;
    }

    public void setProtectionPassword(String protectionPassword) {
        this.protectionPassword = protectionPassword;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetSaveOptions spreadsheetSaveOptions = (SpreadsheetSaveOptions)o;
        return Objects.equals(this.password, spreadsheetSaveOptions.password) && Objects.equals((Object)this.protectionType, (Object)spreadsheetSaveOptions.protectionType) && Objects.equals(this.protectionPassword, spreadsheetSaveOptions.protectionPassword) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.password, this.protectionType, this.protectionPassword, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpreadsheetSaveOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    protectionType: ").append(this.toIndentedString((Object)this.protectionType)).append("\n");
        sb.append("    protectionPassword: ").append(this.toIndentedString(this.protectionPassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtectionTypeEnum {
        NONE("None"),
        ALL("All"),
        CONTENTS("Contents"),
        OBJECTS("Objects"),
        SCENARIOS("Scenarios"),
        STRUCTURE("Structure"),
        WINDOW("Window");

        private String value;

        private ProtectionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtectionTypeEnum fromValue(String text) {
            for (ProtectionTypeEnum b : ProtectionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProtectionTypeEnum> {
            public void write(JsonWriter jsonWriter, ProtectionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProtectionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtectionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

