/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.editor.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for loading plain text (TXT) documents")
public class TextLoadOptions
extends LoadOptions {
    @SerializedName(value="encoding")
    private String encoding = null;
    @SerializedName(value="recognizeLists")
    private Boolean recognizeLists = null;
    @SerializedName(value="leadingSpaces")
    private LeadingSpacesEnum leadingSpaces = null;
    @SerializedName(value="trailingSpaces")
    private TrailingSpacesEnum trailingSpaces = null;
    @SerializedName(value="enablePagination")
    private Boolean enablePagination = null;

    public TextLoadOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Character encoding of the text document, which will be applied for its opening")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public TextLoadOptions recognizeLists(Boolean recognizeLists) {
        this.recognizeLists = recognizeLists;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify how numbered list items are recognized when document is imported from plain text format. The default value is true.")
    public Boolean getRecognizeLists() {
        return this.recognizeLists;
    }

    public void setRecognizeLists(Boolean recognizeLists) {
        this.recognizeLists = recognizeLists;
    }

    public TextLoadOptions leadingSpaces(LeadingSpacesEnum leadingSpaces) {
        this.leadingSpaces = leadingSpaces;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets preferred option of a leading space handling. By default converts leading spaces to the left indent.")
    public LeadingSpacesEnum getLeadingSpaces() {
        return this.leadingSpaces;
    }

    public void setLeadingSpaces(LeadingSpacesEnum leadingSpaces) {
        this.leadingSpaces = leadingSpaces;
    }

    public TextLoadOptions trailingSpaces(TrailingSpacesEnum trailingSpaces) {
        this.trailingSpaces = trailingSpaces;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets preferred option of a trailing space handling. By default truncates all trailing spaces.")
    public TrailingSpacesEnum getTrailingSpaces() {
        return this.trailingSpaces;
    }

    public void setTrailingSpaces(TrailingSpacesEnum trailingSpaces) {
        this.trailingSpaces = trailingSpaces;
    }

    public TextLoadOptions enablePagination(Boolean enablePagination) {
        this.enablePagination = enablePagination;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable or disable pagination in the resultant HTML document. By default is disabled (false).")
    public Boolean getEnablePagination() {
        return this.enablePagination;
    }

    public void setEnablePagination(Boolean enablePagination) {
        this.enablePagination = enablePagination;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextLoadOptions textLoadOptions = (TextLoadOptions)o;
        return Objects.equals(this.encoding, textLoadOptions.encoding) && Objects.equals(this.recognizeLists, textLoadOptions.recognizeLists) && Objects.equals((Object)this.leadingSpaces, (Object)textLoadOptions.leadingSpaces) && Objects.equals((Object)this.trailingSpaces, (Object)textLoadOptions.trailingSpaces) && Objects.equals(this.enablePagination, textLoadOptions.enablePagination) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.encoding, this.recognizeLists, this.leadingSpaces, this.trailingSpaces, this.enablePagination, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    recognizeLists: ").append(this.toIndentedString(this.recognizeLists)).append("\n");
        sb.append("    leadingSpaces: ").append(this.toIndentedString((Object)this.leadingSpaces)).append("\n");
        sb.append("    trailingSpaces: ").append(this.toIndentedString((Object)this.trailingSpaces)).append("\n");
        sb.append("    enablePagination: ").append(this.toIndentedString(this.enablePagination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TrailingSpacesEnum {
        TRIM("Trim"),
        PRESERVE("Preserve");

        private String value;

        private TrailingSpacesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TrailingSpacesEnum fromValue(String text) {
            for (TrailingSpacesEnum b : TrailingSpacesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TrailingSpacesEnum> {
            public void write(JsonWriter jsonWriter, TrailingSpacesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TrailingSpacesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TrailingSpacesEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LeadingSpacesEnum {
        CONVERTTOINDENT("ConvertToIndent"),
        PRESERVE("Preserve"),
        TRIM("Trim");

        private String value;

        private LeadingSpacesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LeadingSpacesEnum fromValue(String text) {
            for (LeadingSpacesEnum b : LeadingSpacesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LeadingSpacesEnum> {
            public void write(JsonWriter jsonWriter, LeadingSpacesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LeadingSpacesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LeadingSpacesEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

