/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.editor.model.SaveOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for generating and saving plain text (TXT) documents")
public class TextSaveOptions
extends SaveOptions {
    @SerializedName(value="encoding")
    private String encoding = null;
    @SerializedName(value="addBidiMarks")
    private Boolean addBidiMarks = null;
    @SerializedName(value="preserveTableLayout")
    private Boolean preserveTableLayout = null;

    public TextSaveOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Character encoding of the text document, which will be applied for its saving")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public TextSaveOptions addBidiMarks(Boolean addBidiMarks) {
        this.addBidiMarks = addBidiMarks;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether to add bi-directional marks before each BiDi run when exporting in plain text format")
    public Boolean getAddBidiMarks() {
        return this.addBidiMarks;
    }

    public void setAddBidiMarks(Boolean addBidiMarks) {
        this.addBidiMarks = addBidiMarks;
    }

    public TextSaveOptions preserveTableLayout(Boolean preserveTableLayout) {
        this.preserveTableLayout = preserveTableLayout;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether the program should attempt to preserve layout of tables when saving in the plain text format. The default value is false.")
    public Boolean getPreserveTableLayout() {
        return this.preserveTableLayout;
    }

    public void setPreserveTableLayout(Boolean preserveTableLayout) {
        this.preserveTableLayout = preserveTableLayout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextSaveOptions textSaveOptions = (TextSaveOptions)o;
        return Objects.equals(this.encoding, textSaveOptions.encoding) && Objects.equals(this.addBidiMarks, textSaveOptions.addBidiMarks) && Objects.equals(this.preserveTableLayout, textSaveOptions.preserveTableLayout) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.encoding, this.addBidiMarks, this.preserveTableLayout, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextSaveOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    addBidiMarks: ").append(this.toIndentedString(this.addBidiMarks)).append("\n");
        sb.append("    preserveTableLayout: ").append(this.toIndentedString(this.preserveTableLayout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

