/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.editor.model.SaveOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for generating and saving WordProcessing-compliant documents")
public class WordProcessingSaveOptions
extends SaveOptions {
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="enablePagination")
    private Boolean enablePagination = null;
    @SerializedName(value="locale")
    private String locale = null;
    @SerializedName(value="localeBi")
    private String localeBi = null;
    @SerializedName(value="localeFarEast")
    private String localeFarEast = null;
    @SerializedName(value="protectionType")
    private ProtectionTypeEnum protectionType = null;
    @SerializedName(value="protectionPassword")
    private String protectionPassword = null;

    public WordProcessingSaveOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Allows to specify document password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WordProcessingSaveOptions enablePagination(Boolean enablePagination) {
        this.enablePagination = enablePagination;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable or disable pagination which will be used for saving the document. If the original document was opened and edited in pagination mode, this option also should be enabled. By default is disabled.")
    public Boolean getEnablePagination() {
        return this.enablePagination;
    }

    public void setEnablePagination(Boolean enablePagination) {
        this.enablePagination = enablePagination;
    }

    public WordProcessingSaveOptions locale(String locale) {
        this.locale = locale;
        return this;
    }

    @ApiModelProperty(value="Allows to set override default locale (language) for the WordProcessing document, which will be applied during its creation. When is not specified (default value), MS Word (or other program) will detect (or choose) the document locale according to its own settings or other factors.")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public WordProcessingSaveOptions localeBi(String localeBi) {
        this.localeBi = localeBi;
        return this;
    }

    @ApiModelProperty(value="Allows to set override locale (language) for the WordProcessing document for the RTL (right-to-left) text, which will be applied during its creation. When is not specified (default value), MS Word (or other program) will detect (or choose) the document RTL locale according to its own settings or other factors.")
    public String getLocaleBi() {
        return this.localeBi;
    }

    public void setLocaleBi(String localeBi) {
        this.localeBi = localeBi;
    }

    public WordProcessingSaveOptions localeFarEast(String localeFarEast) {
        this.localeFarEast = localeFarEast;
        return this;
    }

    @ApiModelProperty(value="Allows to override the locale (language) for the WordProcessing document for the East-Asian text, which will be applied during its creation. When is not specified (default value), MS Word (or other program) will detect (or choose) the document East-Asian locale according to its own settings or other factors.")
    public String getLocaleFarEast() {
        return this.localeFarEast;
    }

    public void setLocaleFarEast(String localeFarEast) {
        this.localeFarEast = localeFarEast;
    }

    public WordProcessingSaveOptions protectionType(ProtectionTypeEnum protectionType) {
        this.protectionType = protectionType;
        return this;
    }

    @ApiModelProperty(required=true, value="Write-protection type. Default value is NoProtection")
    public ProtectionTypeEnum getProtectionType() {
        return this.protectionType;
    }

    public void setProtectionType(ProtectionTypeEnum protectionType) {
        this.protectionType = protectionType;
    }

    public WordProcessingSaveOptions protectionPassword(String protectionPassword) {
        this.protectionPassword = protectionPassword;
        return this;
    }

    @ApiModelProperty(value="Write-protection password. Used when protection type is specified.")
    public String getProtectionPassword() {
        return this.protectionPassword;
    }

    public void setProtectionPassword(String protectionPassword) {
        this.protectionPassword = protectionPassword;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordProcessingSaveOptions wordProcessingSaveOptions = (WordProcessingSaveOptions)o;
        return Objects.equals(this.password, wordProcessingSaveOptions.password) && Objects.equals(this.enablePagination, wordProcessingSaveOptions.enablePagination) && Objects.equals(this.locale, wordProcessingSaveOptions.locale) && Objects.equals(this.localeBi, wordProcessingSaveOptions.localeBi) && Objects.equals(this.localeFarEast, wordProcessingSaveOptions.localeFarEast) && Objects.equals((Object)this.protectionType, (Object)wordProcessingSaveOptions.protectionType) && Objects.equals(this.protectionPassword, wordProcessingSaveOptions.protectionPassword) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.password, this.enablePagination, this.locale, this.localeBi, this.localeFarEast, this.protectionType, this.protectionPassword, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WordProcessingSaveOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    enablePagination: ").append(this.toIndentedString(this.enablePagination)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    localeBi: ").append(this.toIndentedString(this.localeBi)).append("\n");
        sb.append("    localeFarEast: ").append(this.toIndentedString(this.localeFarEast)).append("\n");
        sb.append("    protectionType: ").append(this.toIndentedString((Object)this.protectionType)).append("\n");
        sb.append("    protectionPassword: ").append(this.toIndentedString(this.protectionPassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtectionTypeEnum {
        NOPROTECTION("NoProtection"),
        ALLOWONLYREVISIONS("AllowOnlyRevisions"),
        ALLOWONLYCOMMENTS("AllowOnlyComments"),
        ALLOWONLYFORMFIELDS("AllowOnlyFormFields"),
        READONLY("ReadOnly");

        private String value;

        private ProtectionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtectionTypeEnum fromValue(String text) {
            for (ProtectionTypeEnum b : ProtectionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProtectionTypeEnum> {
            public void write(JsonWriter jsonWriter, ProtectionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProtectionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtectionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

