/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.editor.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for loading XML (eXtensible Markup Language) documents")
public class XmlLoadOptions
extends LoadOptions {
    @SerializedName(value="encoding")
    private String encoding = null;
    @SerializedName(value="fixIncorrectStructure")
    private Boolean fixIncorrectStructure = null;
    @SerializedName(value="recognizeUris")
    private Boolean recognizeUris = null;
    @SerializedName(value="recognizeEmails")
    private Boolean recognizeEmails = null;
    @SerializedName(value="trimTrailingWhitespaces")
    private Boolean trimTrailingWhitespaces = null;
    @SerializedName(value="attributeValuesQuoteType")
    private AttributeValuesQuoteTypeEnum attributeValuesQuoteType = null;

    public XmlLoadOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Character encoding of the text document, which will be applied for its opening. By default is null - internal document encoding will be applied.             ")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public XmlLoadOptions fixIncorrectStructure(Boolean fixIncorrectStructure) {
        this.fixIncorrectStructure = fixIncorrectStructure;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable or disable mechanism for fixing corrupted XML structure. By default is disabled (false).             ")
    public Boolean getFixIncorrectStructure() {
        return this.fixIncorrectStructure;
    }

    public void setFixIncorrectStructure(Boolean fixIncorrectStructure) {
        this.fixIncorrectStructure = fixIncorrectStructure;
    }

    public XmlLoadOptions recognizeUris(Boolean recognizeUris) {
        this.recognizeUris = recognizeUris;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable URI recognition algorithm")
    public Boolean getRecognizeUris() {
        return this.recognizeUris;
    }

    public void setRecognizeUris(Boolean recognizeUris) {
        this.recognizeUris = recognizeUris;
    }

    public XmlLoadOptions recognizeEmails(Boolean recognizeEmails) {
        this.recognizeEmails = recognizeEmails;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable recognition algorithm for email addresses in attribute values")
    public Boolean getRecognizeEmails() {
        return this.recognizeEmails;
    }

    public void setRecognizeEmails(Boolean recognizeEmails) {
        this.recognizeEmails = recognizeEmails;
    }

    public XmlLoadOptions trimTrailingWhitespaces(Boolean trimTrailingWhitespaces) {
        this.trimTrailingWhitespaces = trimTrailingWhitespaces;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to enable the truncation of trailing whitespaces in the inner-tag text. By default is disabled (false) - trailing whitespaces will be preserved.             ")
    public Boolean getTrimTrailingWhitespaces() {
        return this.trimTrailingWhitespaces;
    }

    public void setTrimTrailingWhitespaces(Boolean trimTrailingWhitespaces) {
        this.trimTrailingWhitespaces = trimTrailingWhitespaces;
    }

    public XmlLoadOptions attributeValuesQuoteType(AttributeValuesQuoteTypeEnum attributeValuesQuoteType) {
        this.attributeValuesQuoteType = attributeValuesQuoteType;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify quote type (single or double quotes) for attribute values. Double quotes are default.             ")
    public AttributeValuesQuoteTypeEnum getAttributeValuesQuoteType() {
        return this.attributeValuesQuoteType;
    }

    public void setAttributeValuesQuoteType(AttributeValuesQuoteTypeEnum attributeValuesQuoteType) {
        this.attributeValuesQuoteType = attributeValuesQuoteType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlLoadOptions xmlLoadOptions = (XmlLoadOptions)o;
        return Objects.equals(this.encoding, xmlLoadOptions.encoding) && Objects.equals(this.fixIncorrectStructure, xmlLoadOptions.fixIncorrectStructure) && Objects.equals(this.recognizeUris, xmlLoadOptions.recognizeUris) && Objects.equals(this.recognizeEmails, xmlLoadOptions.recognizeEmails) && Objects.equals(this.trimTrailingWhitespaces, xmlLoadOptions.trimTrailingWhitespaces) && Objects.equals((Object)this.attributeValuesQuoteType, (Object)xmlLoadOptions.attributeValuesQuoteType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.encoding, this.fixIncorrectStructure, this.recognizeUris, this.recognizeEmails, this.trimTrailingWhitespaces, this.attributeValuesQuoteType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XmlLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    fixIncorrectStructure: ").append(this.toIndentedString(this.fixIncorrectStructure)).append("\n");
        sb.append("    recognizeUris: ").append(this.toIndentedString(this.recognizeUris)).append("\n");
        sb.append("    recognizeEmails: ").append(this.toIndentedString(this.recognizeEmails)).append("\n");
        sb.append("    trimTrailingWhitespaces: ").append(this.toIndentedString(this.trimTrailingWhitespaces)).append("\n");
        sb.append("    attributeValuesQuoteType: ").append(this.toIndentedString((Object)this.attributeValuesQuoteType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AttributeValuesQuoteTypeEnum {
        DOUBLEQUOTE("DoubleQuote"),
        SINGLEQUOTE("SingleQuote");

        private String value;

        private AttributeValuesQuoteTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AttributeValuesQuoteTypeEnum fromValue(String text) {
            for (AttributeValuesQuoteTypeEnum b : AttributeValuesQuoteTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AttributeValuesQuoteTypeEnum> {
            public void write(JsonWriter jsonWriter, AttributeValuesQuoteTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AttributeValuesQuoteTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AttributeValuesQuoteTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

