/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.merger.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.merger.client.ApiCallback;
import com.groupdocs.cloud.merger.client.ApiClient;
import com.groupdocs.cloud.merger.client.ApiException;
import com.groupdocs.cloud.merger.client.ApiResponse;
import com.groupdocs.cloud.merger.client.Configuration;
import com.groupdocs.cloud.merger.client.Pair;
import com.groupdocs.cloud.merger.client.ProgressRequestBody;
import com.groupdocs.cloud.merger.client.ProgressResponseBody;
import com.groupdocs.cloud.merger.model.DocumentResult;
import com.groupdocs.cloud.merger.model.Options;
import com.groupdocs.cloud.merger.model.PasswordResult;
import com.groupdocs.cloud.merger.model.UpdatePasswordOptions;
import com.groupdocs.cloud.merger.model.requests.AddPasswordRequest;
import com.groupdocs.cloud.merger.model.requests.CheckPasswordRequest;
import com.groupdocs.cloud.merger.model.requests.RemovePasswordRequest;
import com.groupdocs.cloud.merger.model.requests.UpdatePasswordRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SecurityApi {
    private ApiClient apiClient;

    public SecurityApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public SecurityApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addPasswordCall(AddPasswordRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Options localVarPostBody = request.getoptions();
        String localVarPath = "/merger/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addPasswordValidateBeforeCall(AddPasswordRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling addPassword(Async)");
        }
        Call call = this.addPasswordCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult addPassword(AddPasswordRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.addPasswordWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> addPasswordWithHttpInfo(AddPasswordRequest request) throws ApiException {
        Call call = this.addPasswordValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addPasswordAsync(AddPasswordRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addPasswordValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call checkPasswordCall(CheckPasswordRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/merger/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getfilePath() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filePath", request.getfilePath()));
        }
        if (request.getstorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storageName", request.getstorageName()));
        }
        if (request.getversionId() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versionId", request.getversionId()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call checkPasswordValidateBeforeCall(CheckPasswordRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getfilePath() == null) {
            throw new ApiException("Missing the required parameter 'filePath' when calling checkPassword(Async)");
        }
        Call call = this.checkPasswordCall(request, progressListener, progressRequestListener);
        return call;
    }

    public PasswordResult checkPassword(CheckPasswordRequest request) throws ApiException {
        ApiResponse<PasswordResult> resp = this.checkPasswordWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<PasswordResult> checkPasswordWithHttpInfo(CheckPasswordRequest request) throws ApiException {
        Call call = this.checkPasswordValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<PasswordResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call checkPasswordAsync(CheckPasswordRequest request, final ApiCallback<PasswordResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.checkPasswordValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PasswordResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removePasswordCall(RemovePasswordRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Options localVarPostBody = request.getoptions();
        String localVarPath = "/merger/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removePasswordValidateBeforeCall(RemovePasswordRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling removePassword(Async)");
        }
        Call call = this.removePasswordCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult removePassword(RemovePasswordRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.removePasswordWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> removePasswordWithHttpInfo(RemovePasswordRequest request) throws ApiException {
        Call call = this.removePasswordValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removePasswordAsync(RemovePasswordRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removePasswordValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatePasswordCall(UpdatePasswordRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatePasswordOptions localVarPostBody = request.getoptions();
        String localVarPath = "/merger/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatePasswordValidateBeforeCall(UpdatePasswordRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling updatePassword(Async)");
        }
        Call call = this.updatePasswordCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult updatePassword(UpdatePasswordRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.updatePasswordWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> updatePasswordWithHttpInfo(UpdatePasswordRequest request) throws ApiException {
        Call call = this.updatePasswordValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatePasswordAsync(UpdatePasswordRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatePasswordValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

