/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.merger.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.merger.model.FileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Describes document for join operation.")
public class JoinItem {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="pages")
    private List<Integer> pages = null;
    @SerializedName(value="startPageNumber")
    private Integer startPageNumber = null;
    @SerializedName(value="endPageNumber")
    private Integer endPageNumber = null;
    @SerializedName(value="rangeMode")
    private RangeModeEnum rangeMode = null;
    @SerializedName(value="wordJoinMode")
    private WordJoinModeEnum wordJoinMode = null;
    @SerializedName(value="wordJoinCompliance")
    private WordJoinComplianceEnum wordJoinCompliance = null;
    @SerializedName(value="imageJoinMode")
    private ImageJoinModeEnum imageJoinMode = null;

    public JoinItem fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="File info.")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public JoinItem pages(List<Integer> pages) {
        this.pages = pages;
        return this;
    }

    public JoinItem addPagesItem(Integer pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<Integer>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    @ApiModelProperty(value="List of page numbers to use in a Join operation. NOTE: page numbering starts from 1.")
    public List<Integer> getPages() {
        return this.pages;
    }

    public void setPages(List<Integer> pages) {
        this.pages = pages;
    }

    public JoinItem startPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Start page number. Ignored if Pages collection is not empty.")
    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public void setStartPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
    }

    public JoinItem endPageNumber(Integer endPageNumber) {
        this.endPageNumber = endPageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="End page number. Ignored if Pages collection is not empty.")
    public Integer getEndPageNumber() {
        return this.endPageNumber;
    }

    public void setEndPageNumber(Integer endPageNumber) {
        this.endPageNumber = endPageNumber;
    }

    public JoinItem rangeMode(RangeModeEnum rangeMode) {
        this.rangeMode = rangeMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Range mode. Ignored if Pages collection is not empty. Default value is AllPages.")
    public RangeModeEnum getRangeMode() {
        return this.rangeMode;
    }

    public void setRangeMode(RangeModeEnum rangeMode) {
        this.rangeMode = rangeMode;
    }

    public JoinItem wordJoinMode(WordJoinModeEnum wordJoinMode) {
        this.wordJoinMode = wordJoinMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to join word documents without empty space between documents.")
    public WordJoinModeEnum getWordJoinMode() {
        return this.wordJoinMode;
    }

    public void setWordJoinMode(WordJoinModeEnum wordJoinMode) {
        this.wordJoinMode = wordJoinMode;
    }

    public JoinItem wordJoinCompliance(WordJoinComplianceEnum wordJoinCompliance) {
        this.wordJoinCompliance = wordJoinCompliance;
        return this;
    }

    @ApiModelProperty(required=true, value="Compliance mode for the Word Ooxml format")
    public WordJoinComplianceEnum getWordJoinCompliance() {
        return this.wordJoinCompliance;
    }

    public void setWordJoinCompliance(WordJoinComplianceEnum wordJoinCompliance) {
        this.wordJoinCompliance = wordJoinCompliance;
    }

    public JoinItem imageJoinMode(ImageJoinModeEnum imageJoinMode) {
        this.imageJoinMode = imageJoinMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Possible modes for the image joining.")
    public ImageJoinModeEnum getImageJoinMode() {
        return this.imageJoinMode;
    }

    public void setImageJoinMode(ImageJoinModeEnum imageJoinMode) {
        this.imageJoinMode = imageJoinMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinItem joinItem = (JoinItem)o;
        return Objects.equals(this.fileInfo, joinItem.fileInfo) && Objects.equals(this.pages, joinItem.pages) && Objects.equals(this.startPageNumber, joinItem.startPageNumber) && Objects.equals(this.endPageNumber, joinItem.endPageNumber) && Objects.equals((Object)this.rangeMode, (Object)joinItem.rangeMode) && Objects.equals((Object)this.wordJoinMode, (Object)joinItem.wordJoinMode) && Objects.equals((Object)this.wordJoinCompliance, (Object)joinItem.wordJoinCompliance) && Objects.equals((Object)this.imageJoinMode, (Object)joinItem.imageJoinMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileInfo, this.pages, this.startPageNumber, this.endPageNumber, this.rangeMode, this.wordJoinMode, this.wordJoinCompliance, this.imageJoinMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JoinItem {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    startPageNumber: ").append(this.toIndentedString(this.startPageNumber)).append("\n");
        sb.append("    endPageNumber: ").append(this.toIndentedString(this.endPageNumber)).append("\n");
        sb.append("    rangeMode: ").append(this.toIndentedString((Object)this.rangeMode)).append("\n");
        sb.append("    wordJoinMode: ").append(this.toIndentedString((Object)this.wordJoinMode)).append("\n");
        sb.append("    wordJoinCompliance: ").append(this.toIndentedString((Object)this.wordJoinCompliance)).append("\n");
        sb.append("    imageJoinMode: ").append(this.toIndentedString((Object)this.imageJoinMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImageJoinModeEnum {
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical");

        private String value;

        private ImageJoinModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImageJoinModeEnum fromValue(String text) {
            for (ImageJoinModeEnum b : ImageJoinModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImageJoinModeEnum> {
            public void write(JsonWriter jsonWriter, ImageJoinModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImageJoinModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImageJoinModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WordJoinComplianceEnum {
        ECMA376_2006("Ecma376_2006"),
        ISO29500_2008_TRANSITIONAL("Iso29500_2008_Transitional"),
        ISO29500_2008_STRICT("Iso29500_2008_Strict"),
        AUTO("Auto");

        private String value;

        private WordJoinComplianceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WordJoinComplianceEnum fromValue(String text) {
            for (WordJoinComplianceEnum b : WordJoinComplianceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WordJoinComplianceEnum> {
            public void write(JsonWriter jsonWriter, WordJoinComplianceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WordJoinComplianceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WordJoinComplianceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WordJoinModeEnum {
        DEFAULT("Default"),
        CONTINUOUS("Continuous");

        private String value;

        private WordJoinModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WordJoinModeEnum fromValue(String text) {
            for (WordJoinModeEnum b : WordJoinModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WordJoinModeEnum> {
            public void write(JsonWriter jsonWriter, WordJoinModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WordJoinModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WordJoinModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeModeEnum {
        ALLPAGES("AllPages"),
        ODDPAGES("OddPages"),
        EVENPAGES("EvenPages");

        private String value;

        private RangeModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeModeEnum fromValue(String text) {
            for (RangeModeEnum b : RangeModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RangeModeEnum> {
            public void write(JsonWriter jsonWriter, RangeModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RangeModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RangeModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

