/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.merger.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.merger.model.FileInfo;
import com.groupdocs.cloud.merger.model.MixPagesItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines options for documents JoinPages method")
public class MixPagesOptions {
    @SerializedName(value="files")
    private List<FileInfo> files = null;
    @SerializedName(value="filesPages")
    private List<MixPagesItem> filesPages = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;
    @SerializedName(value="wordJoinMode")
    private WordJoinModeEnum wordJoinMode = null;
    @SerializedName(value="wordJoinCompliance")
    private WordJoinComplianceEnum wordJoinCompliance = null;
    @SerializedName(value="imageJoinMode")
    private ImageJoinModeEnum imageJoinMode = null;

    public MixPagesOptions files(List<FileInfo> files) {
        this.files = files;
        return this;
    }

    public MixPagesOptions addFilesItem(FileInfo filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<FileInfo>();
        }
        this.files.add(filesItem);
        return this;
    }

    @ApiModelProperty(value="Source documents for JoinPages operation")
    public List<FileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileInfo> files) {
        this.files = files;
    }

    public MixPagesOptions filesPages(List<MixPagesItem> filesPages) {
        this.filesPages = filesPages;
        return this;
    }

    public MixPagesOptions addFilesPagesItem(MixPagesItem filesPagesItem) {
        if (this.filesPages == null) {
            this.filesPages = new ArrayList<MixPagesItem>();
        }
        this.filesPages.add(filesPagesItem);
        return this;
    }

    @ApiModelProperty(value="Page numbers for document indicies in Files collection.")
    public List<MixPagesItem> getFilesPages() {
        return this.filesPages;
    }

    public void setFilesPages(List<MixPagesItem> filesPages) {
        this.filesPages = filesPages;
    }

    public MixPagesOptions outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="The output path")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public MixPagesOptions wordJoinMode(WordJoinModeEnum wordJoinMode) {
        this.wordJoinMode = wordJoinMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to join word documents without empty space between documents.")
    public WordJoinModeEnum getWordJoinMode() {
        return this.wordJoinMode;
    }

    public void setWordJoinMode(WordJoinModeEnum wordJoinMode) {
        this.wordJoinMode = wordJoinMode;
    }

    public MixPagesOptions wordJoinCompliance(WordJoinComplianceEnum wordJoinCompliance) {
        this.wordJoinCompliance = wordJoinCompliance;
        return this;
    }

    @ApiModelProperty(required=true, value="Compliance mode for the Word Ooxml format")
    public WordJoinComplianceEnum getWordJoinCompliance() {
        return this.wordJoinCompliance;
    }

    public void setWordJoinCompliance(WordJoinComplianceEnum wordJoinCompliance) {
        this.wordJoinCompliance = wordJoinCompliance;
    }

    public MixPagesOptions imageJoinMode(ImageJoinModeEnum imageJoinMode) {
        this.imageJoinMode = imageJoinMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Possible modes for the image joining.")
    public ImageJoinModeEnum getImageJoinMode() {
        return this.imageJoinMode;
    }

    public void setImageJoinMode(ImageJoinModeEnum imageJoinMode) {
        this.imageJoinMode = imageJoinMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MixPagesOptions mixPagesOptions = (MixPagesOptions)o;
        return Objects.equals(this.files, mixPagesOptions.files) && Objects.equals(this.filesPages, mixPagesOptions.filesPages) && Objects.equals(this.outputPath, mixPagesOptions.outputPath) && Objects.equals((Object)this.wordJoinMode, (Object)mixPagesOptions.wordJoinMode) && Objects.equals((Object)this.wordJoinCompliance, (Object)mixPagesOptions.wordJoinCompliance) && Objects.equals((Object)this.imageJoinMode, (Object)mixPagesOptions.imageJoinMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.files, this.filesPages, this.outputPath, this.wordJoinMode, this.wordJoinCompliance, this.imageJoinMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MixPagesOptions {\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    filesPages: ").append(this.toIndentedString(this.filesPages)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("    wordJoinMode: ").append(this.toIndentedString((Object)this.wordJoinMode)).append("\n");
        sb.append("    wordJoinCompliance: ").append(this.toIndentedString((Object)this.wordJoinCompliance)).append("\n");
        sb.append("    imageJoinMode: ").append(this.toIndentedString((Object)this.imageJoinMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImageJoinModeEnum {
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical");

        private String value;

        private ImageJoinModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImageJoinModeEnum fromValue(String text) {
            for (ImageJoinModeEnum b : ImageJoinModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImageJoinModeEnum> {
            public void write(JsonWriter jsonWriter, ImageJoinModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImageJoinModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImageJoinModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WordJoinComplianceEnum {
        ECMA376_2006("Ecma376_2006"),
        ISO29500_2008_TRANSITIONAL("Iso29500_2008_Transitional"),
        ISO29500_2008_STRICT("Iso29500_2008_Strict"),
        AUTO("Auto");

        private String value;

        private WordJoinComplianceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WordJoinComplianceEnum fromValue(String text) {
            for (WordJoinComplianceEnum b : WordJoinComplianceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WordJoinComplianceEnum> {
            public void write(JsonWriter jsonWriter, WordJoinComplianceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WordJoinComplianceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WordJoinComplianceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WordJoinModeEnum {
        DEFAULT("Default"),
        CONTINUOUS("Continuous");

        private String value;

        private WordJoinModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WordJoinModeEnum fromValue(String text) {
            for (WordJoinModeEnum b : WordJoinModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WordJoinModeEnum> {
            public void write(JsonWriter jsonWriter, WordJoinModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WordJoinModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WordJoinModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

