/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.merger.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.merger.client.ApiCallback;
import com.groupdocs.cloud.merger.client.ApiClient;
import com.groupdocs.cloud.merger.client.ApiException;
import com.groupdocs.cloud.merger.client.ApiResponse;
import com.groupdocs.cloud.merger.client.Configuration;
import com.groupdocs.cloud.merger.client.Pair;
import com.groupdocs.cloud.merger.client.ProgressRequestBody;
import com.groupdocs.cloud.merger.client.ProgressResponseBody;
import com.groupdocs.cloud.merger.model.DocumentResult;
import com.groupdocs.cloud.merger.model.ImportOptions;
import com.groupdocs.cloud.merger.model.JoinOptions;
import com.groupdocs.cloud.merger.model.MixPagesOptions;
import com.groupdocs.cloud.merger.model.MultiDocumentResult;
import com.groupdocs.cloud.merger.model.PreviewOptions;
import com.groupdocs.cloud.merger.model.SplitOptions;
import com.groupdocs.cloud.merger.model.requests.CallImportRequest;
import com.groupdocs.cloud.merger.model.requests.JoinRequest;
import com.groupdocs.cloud.merger.model.requests.MixRequest;
import com.groupdocs.cloud.merger.model.requests.PreviewRequest;
import com.groupdocs.cloud.merger.model.requests.SplitRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DocumentApi {
    private ApiClient apiClient;

    public DocumentApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public DocumentApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call callImportCall(CallImportRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ImportOptions localVarPostBody = request.getoptions();
        String localVarPath = "/merger/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call callImportValidateBeforeCall(CallImportRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling callImport(Async)");
        }
        Call call = this.callImportCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult callImport(CallImportRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.callImportWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> callImportWithHttpInfo(CallImportRequest request) throws ApiException {
        Call call = this.callImportValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call callImportAsync(CallImportRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.callImportValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call joinCall(JoinRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        JoinOptions localVarPostBody = request.getoptions();
        String localVarPath = "/merger/join";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call joinValidateBeforeCall(JoinRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling join(Async)");
        }
        Call call = this.joinCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult join(JoinRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.joinWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> joinWithHttpInfo(JoinRequest request) throws ApiException {
        Call call = this.joinValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call joinAsync(JoinRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.joinValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call mixCall(MixRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MixPagesOptions localVarPostBody = request.getoptions();
        String localVarPath = "/merger/mix";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call mixValidateBeforeCall(MixRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling mix(Async)");
        }
        Call call = this.mixCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult mix(MixRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.mixWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> mixWithHttpInfo(MixRequest request) throws ApiException {
        Call call = this.mixValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call mixAsync(MixRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mixValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call previewCall(PreviewRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PreviewOptions localVarPostBody = request.getoptions();
        String localVarPath = "/merger/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call previewValidateBeforeCall(PreviewRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling preview(Async)");
        }
        Call call = this.previewCall(request, progressListener, progressRequestListener);
        return call;
    }

    public MultiDocumentResult preview(PreviewRequest request) throws ApiException {
        ApiResponse<MultiDocumentResult> resp = this.previewWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<MultiDocumentResult> previewWithHttpInfo(PreviewRequest request) throws ApiException {
        Call call = this.previewValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<MultiDocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call previewAsync(PreviewRequest request, final ApiCallback<MultiDocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.previewValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultiDocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call splitCall(SplitRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SplitOptions localVarPostBody = request.getoptions();
        String localVarPath = "/merger/split";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call splitValidateBeforeCall(SplitRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling split(Async)");
        }
        Call call = this.splitCall(request, progressListener, progressRequestListener);
        return call;
    }

    public MultiDocumentResult split(SplitRequest request) throws ApiException {
        ApiResponse<MultiDocumentResult> resp = this.splitWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<MultiDocumentResult> splitWithHttpInfo(SplitRequest request) throws ApiException {
        Call call = this.splitValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<MultiDocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call splitAsync(SplitRequest request, final ApiCallback<MultiDocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.splitValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultiDocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

