/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.merger.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.merger.model.Options;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Describes options for specifying page or pages range")
public class PageOptions
extends Options {
    @SerializedName(value="pages")
    private List<Integer> pages = null;
    @SerializedName(value="startPageNumber")
    private Integer startPageNumber = null;
    @SerializedName(value="endPageNumber")
    private Integer endPageNumber = null;
    @SerializedName(value="rangeMode")
    private RangeModeEnum rangeMode = null;

    public PageOptions pages(List<Integer> pages) {
        this.pages = pages;
        return this;
    }

    public PageOptions addPagesItem(Integer pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<Integer>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    @ApiModelProperty(value="List of page numbers to use in a specific API method. NOTE: page numbering starts from 1.")
    public List<Integer> getPages() {
        return this.pages;
    }

    public void setPages(List<Integer> pages) {
        this.pages = pages;
    }

    public PageOptions startPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Start page number. Ignored if Pages collection is not empty.")
    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public void setStartPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
    }

    public PageOptions endPageNumber(Integer endPageNumber) {
        this.endPageNumber = endPageNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="End page number. Ignored if Pages collection is not empty.")
    public Integer getEndPageNumber() {
        return this.endPageNumber;
    }

    public void setEndPageNumber(Integer endPageNumber) {
        this.endPageNumber = endPageNumber;
    }

    public PageOptions rangeMode(RangeModeEnum rangeMode) {
        this.rangeMode = rangeMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Range mode. Ignored if Pages collection is not empty. Default value is AllPages.")
    public RangeModeEnum getRangeMode() {
        return this.rangeMode;
    }

    public void setRangeMode(RangeModeEnum rangeMode) {
        this.rangeMode = rangeMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageOptions pageOptions = (PageOptions)o;
        return Objects.equals(this.pages, pageOptions.pages) && Objects.equals(this.startPageNumber, pageOptions.startPageNumber) && Objects.equals(this.endPageNumber, pageOptions.endPageNumber) && Objects.equals((Object)this.rangeMode, (Object)pageOptions.rangeMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.pages, this.startPageNumber, this.endPageNumber, this.rangeMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    startPageNumber: ").append(this.toIndentedString(this.startPageNumber)).append("\n");
        sb.append("    endPageNumber: ").append(this.toIndentedString(this.endPageNumber)).append("\n");
        sb.append("    rangeMode: ").append(this.toIndentedString((Object)this.rangeMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeModeEnum {
        ALLPAGES("AllPages"),
        ODDPAGES("OddPages"),
        EVENPAGES("EvenPages");

        private String value;

        private RangeModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeModeEnum fromValue(String text) {
            for (RangeModeEnum b : RangeModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RangeModeEnum> {
            public void write(JsonWriter jsonWriter, RangeModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RangeModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RangeModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

