/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.metadata.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.metadata.model.MetadataProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Metadata package")
public class MetadataPackage {
    @SerializedName(value="packageName")
    private String packageName = null;
    @SerializedName(value="packageProperties")
    private List<MetadataProperty> packageProperties = null;
    @SerializedName(value="innerPackages")
    private List<MetadataPackage> innerPackages = null;

    public MetadataPackage packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    @ApiModelProperty(value="Name of the metadata package.")
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public MetadataPackage packageProperties(List<MetadataProperty> packageProperties) {
        this.packageProperties = packageProperties;
        return this;
    }

    public MetadataPackage addPackagePropertiesItem(MetadataProperty packagePropertiesItem) {
        if (this.packageProperties == null) {
            this.packageProperties = new ArrayList<MetadataProperty>();
        }
        this.packageProperties.add(packagePropertiesItem);
        return this;
    }

    @ApiModelProperty(value="Properties of the metadata package.")
    public List<MetadataProperty> getPackageProperties() {
        return this.packageProperties;
    }

    public void setPackageProperties(List<MetadataProperty> packageProperties) {
        this.packageProperties = packageProperties;
    }

    public MetadataPackage innerPackages(List<MetadataPackage> innerPackages) {
        this.innerPackages = innerPackages;
        return this;
    }

    public MetadataPackage addInnerPackagesItem(MetadataPackage innerPackagesItem) {
        if (this.innerPackages == null) {
            this.innerPackages = new ArrayList<MetadataPackage>();
        }
        this.innerPackages.add(innerPackagesItem);
        return this;
    }

    @ApiModelProperty(value="Inner packages of current metadata package.")
    public List<MetadataPackage> getInnerPackages() {
        return this.innerPackages;
    }

    public void setInnerPackages(List<MetadataPackage> innerPackages) {
        this.innerPackages = innerPackages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataPackage metadataPackage = (MetadataPackage)o;
        return Objects.equals(this.packageName, metadataPackage.packageName) && Objects.equals(this.packageProperties, metadataPackage.packageProperties) && Objects.equals(this.innerPackages, metadataPackage.innerPackages);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.packageProperties, this.innerPackages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataPackage {\n");
        sb.append("    packageName: ").append(this.toIndentedString(this.packageName)).append("\n");
        sb.append("    packageProperties: ").append(this.toIndentedString(this.packageProperties)).append("\n");
        sb.append("    innerPackages: ").append(this.toIndentedString(this.innerPackages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

