/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.parser.client.ApiCallback;
import com.groupdocs.cloud.parser.client.ApiClient;
import com.groupdocs.cloud.parser.client.ApiException;
import com.groupdocs.cloud.parser.client.ApiResponse;
import com.groupdocs.cloud.parser.client.Configuration;
import com.groupdocs.cloud.parser.client.Pair;
import com.groupdocs.cloud.parser.client.ProgressRequestBody;
import com.groupdocs.cloud.parser.client.ProgressResponseBody;
import com.groupdocs.cloud.parser.model.CreateTemplateOptions;
import com.groupdocs.cloud.parser.model.Template;
import com.groupdocs.cloud.parser.model.TemplateOptions;
import com.groupdocs.cloud.parser.model.TemplateResult;
import com.groupdocs.cloud.parser.model.requests.CreateTemplateRequest;
import com.groupdocs.cloud.parser.model.requests.DeleteTemplateRequest;
import com.groupdocs.cloud.parser.model.requests.GetTemplateRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class TemplateApi {
    private ApiClient apiClient;

    public TemplateApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public TemplateApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createTemplateCall(CreateTemplateRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateTemplateOptions localVarPostBody = request.getoptions();
        String localVarPath = "/parser/template";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createTemplateValidateBeforeCall(CreateTemplateRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling createTemplate(Async)");
        }
        Call call = this.createTemplateCall(request, progressListener, progressRequestListener);
        return call;
    }

    public TemplateResult createTemplate(CreateTemplateRequest request) throws ApiException {
        ApiResponse<TemplateResult> resp = this.createTemplateWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<TemplateResult> createTemplateWithHttpInfo(CreateTemplateRequest request) throws ApiException {
        Call call = this.createTemplateValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<TemplateResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createTemplateAsync(CreateTemplateRequest request, final ApiCallback<TemplateResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTemplateValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TemplateResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteTemplateCall(DeleteTemplateRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TemplateOptions localVarPostBody = request.getoptions();
        String localVarPath = "/parser/template";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTemplateValidateBeforeCall(DeleteTemplateRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling deleteTemplate(Async)");
        }
        Call call = this.deleteTemplateCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTemplate(DeleteTemplateRequest request) throws ApiException {
        this.deleteTemplateWithHttpInfo(request);
    }

    public ApiResponse<Void> deleteTemplateWithHttpInfo(DeleteTemplateRequest request) throws ApiException {
        Call call = this.deleteTemplateValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTemplateAsync(DeleteTemplateRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTemplateValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getTemplateCall(GetTemplateRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TemplateOptions localVarPostBody = request.getoptions();
        String localVarPath = "/parser/template";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTemplateValidateBeforeCall(GetTemplateRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling getTemplate(Async)");
        }
        Call call = this.getTemplateCall(request, progressListener, progressRequestListener);
        return call;
    }

    public Template getTemplate(GetTemplateRequest request) throws ApiException {
        ApiResponse<Template> resp = this.getTemplateWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<Template> getTemplateWithHttpInfo(GetTemplateRequest request) throws ApiException {
        Call call = this.getTemplateValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<Template>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTemplateAsync(GetTemplateRequest request, final ApiCallback<Template> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTemplateValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Template>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

