/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.BarcodePage;
import com.groupdocs.cloud.parser.model.Rectangle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an barcode.")
public class Barcode {
    @SerializedName(value="codeTypeName")
    private String codeTypeName = null;
    @SerializedName(value="page")
    private BarcodePage page = null;
    @SerializedName(value="rectangle")
    private Rectangle rectangle = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="downloadUrl")
    private String downloadUrl = null;

    public Barcode codeTypeName(String codeTypeName) {
        this.codeTypeName = codeTypeName;
        return this;
    }

    @ApiModelProperty(value="Gets the name of the barcode type.")
    public String getCodeTypeName() {
        return this.codeTypeName;
    }

    public void setCodeTypeName(String codeTypeName) {
        this.codeTypeName = codeTypeName;
    }

    public Barcode page(BarcodePage page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(value="Gets the document page information such as page index and page size.")
    public BarcodePage getPage() {
        return this.page;
    }

    public void setPage(BarcodePage page) {
        this.page = page;
    }

    public Barcode rectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        return this;
    }

    @ApiModelProperty(value="Gets the rectangular area.")
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Barcode value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Gets the barcode value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Barcode downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the barcode download URL.")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Barcode barcode = (Barcode)o;
        return Objects.equals(this.codeTypeName, barcode.codeTypeName) && Objects.equals(this.page, barcode.page) && Objects.equals(this.rectangle, barcode.rectangle) && Objects.equals(this.value, barcode.value) && Objects.equals(this.downloadUrl, barcode.downloadUrl);
    }

    public int hashCode() {
        return Objects.hash(this.codeTypeName, this.page, this.rectangle, this.value, this.downloadUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Barcode {\n");
        sb.append("    codeTypeName: ").append(this.toIndentedString(this.codeTypeName)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    rectangle: ").append(this.toIndentedString(this.rectangle)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

