/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a container item like Zip archive entity, email attachment, PDF Portfolio item and so on.")
public class ContainerItem {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="filePath")
    private String filePath = null;
    @SerializedName(value="directory")
    private String directory = null;
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;

    public ContainerItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the name of the item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerItem filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the full path of the item.")
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public ContainerItem directory(String directory) {
        this.directory = directory;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the directory of the item.")
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public ContainerItem metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ContainerItem putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the collection of metadata items.")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerItem containerItem = (ContainerItem)o;
        return Objects.equals(this.name, containerItem.name) && Objects.equals(this.filePath, containerItem.filePath) && Objects.equals(this.directory, containerItem.directory) && Objects.equals(this.metadata, containerItem.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.filePath, this.directory, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerItem {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    filePath: ").append(this.toIndentedString(this.filePath)).append("\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

