/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.Rectangle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an image.")
public class Image {
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="downloadUrl")
    private String downloadUrl = null;
    @SerializedName(value="pageIndex")
    private Integer pageIndex = null;
    @SerializedName(value="rotation")
    private Double rotation = null;
    @SerializedName(value="fileFormat")
    private String fileFormat = null;
    @SerializedName(value="rectangle")
    private Rectangle rectangle = null;

    public Image path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Gets or sets The path of the image, located in the storage.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Image downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the image download URL.")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Image pageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the index of the page.")
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Image rotation(Double rotation) {
        this.rotation = rotation;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the rotation of the image in degrees.")
    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double rotation) {
        this.rotation = rotation;
    }

    public Image fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the image file format.")
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Image rectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the rectangle area of the image.")
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image image = (Image)o;
        return Objects.equals(this.path, image.path) && Objects.equals(this.downloadUrl, image.downloadUrl) && Objects.equals(this.pageIndex, image.pageIndex) && Objects.equals(this.rotation, image.rotation) && Objects.equals(this.fileFormat, image.fileFormat) && Objects.equals(this.rectangle, image.rectangle);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.downloadUrl, this.pageIndex, this.rotation, this.fileFormat, this.rectangle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Image {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.pageIndex)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString(this.fileFormat)).append("\n");
        sb.append("    rectangle: ").append(this.toIndentedString(this.rectangle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

