/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.DetectorParameters;
import com.groupdocs.cloud.parser.model.TableLayout;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Document template table")
public class Table {
    @SerializedName(value="tableName")
    private String tableName = null;
    @SerializedName(value="pageIndex")
    private Integer pageIndex = null;
    @SerializedName(value="detectorParameters")
    private DetectorParameters detectorParameters = null;
    @SerializedName(value="tableLayout")
    private TableLayout tableLayout = null;

    public Table tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a unique template table name.")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Table pageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    @ApiModelProperty(value="The page index. An integer value that represents the index of the page where the template item is located; null if the template item is located on any page.")
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Table detectorParameters(DetectorParameters detectorParameters) {
        this.detectorParameters = detectorParameters;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the detector parameters. Provides parameters for the table detection algorithms. ")
    public DetectorParameters getDetectorParameters() {
        return this.detectorParameters;
    }

    public void setDetectorParameters(DetectorParameters detectorParameters) {
        this.detectorParameters = detectorParameters;
    }

    public Table tableLayout(TableLayout tableLayout) {
        this.tableLayout = tableLayout;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table layout. Provides the template table layout which is used by Table to define table position.")
    public TableLayout getTableLayout() {
        return this.tableLayout;
    }

    public void setTableLayout(TableLayout tableLayout) {
        this.tableLayout = tableLayout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.tableName, table.tableName) && Objects.equals(this.pageIndex, table.pageIndex) && Objects.equals(this.detectorParameters, table.detectorParameters) && Objects.equals(this.tableLayout, table.tableLayout);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.pageIndex, this.detectorParameters, this.tableLayout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Table {\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.pageIndex)).append("\n");
        sb.append("    detectorParameters: ").append(this.toIndentedString(this.detectorParameters)).append("\n");
        sb.append("    tableLayout: ").append(this.toIndentedString(this.tableLayout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

