/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides the template table layout which is used by Table to define table position.")
public class TableLayout {
    @SerializedName(value="verticalSeparators")
    private List<Double> verticalSeparators = null;
    @SerializedName(value="horizontalSeparators")
    private List<Double> horizontalSeparators = null;

    public TableLayout verticalSeparators(List<Double> verticalSeparators) {
        this.verticalSeparators = verticalSeparators;
        return this;
    }

    public TableLayout addVerticalSeparatorsItem(Double verticalSeparatorsItem) {
        if (this.verticalSeparators == null) {
            this.verticalSeparators = new ArrayList<Double>();
        }
        this.verticalSeparators.add(verticalSeparatorsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table columns separators.")
    public List<Double> getVerticalSeparators() {
        return this.verticalSeparators;
    }

    public void setVerticalSeparators(List<Double> verticalSeparators) {
        this.verticalSeparators = verticalSeparators;
    }

    public TableLayout horizontalSeparators(List<Double> horizontalSeparators) {
        this.horizontalSeparators = horizontalSeparators;
        return this;
    }

    public TableLayout addHorizontalSeparatorsItem(Double horizontalSeparatorsItem) {
        if (this.horizontalSeparators == null) {
            this.horizontalSeparators = new ArrayList<Double>();
        }
        this.horizontalSeparators.add(horizontalSeparatorsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table rows separators.")
    public List<Double> getHorizontalSeparators() {
        return this.horizontalSeparators;
    }

    public void setHorizontalSeparators(List<Double> horizontalSeparators) {
        this.horizontalSeparators = horizontalSeparators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableLayout tableLayout = (TableLayout)o;
        return Objects.equals(this.verticalSeparators, tableLayout.verticalSeparators) && Objects.equals(this.horizontalSeparators, tableLayout.horizontalSeparators);
    }

    public int hashCode() {
        return Objects.hash(this.verticalSeparators, this.horizontalSeparators);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableLayout {\n");
        sb.append("    verticalSeparators: ").append(this.toIndentedString(this.verticalSeparators)).append("\n");
        sb.append("    horizontalSeparators: ").append(this.toIndentedString(this.horizontalSeparators)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

