/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.parser.client.ApiCallback;
import com.groupdocs.cloud.parser.client.ApiClient;
import com.groupdocs.cloud.parser.client.ApiException;
import com.groupdocs.cloud.parser.client.ApiResponse;
import com.groupdocs.cloud.parser.client.Configuration;
import com.groupdocs.cloud.parser.client.Pair;
import com.groupdocs.cloud.parser.client.ProgressRequestBody;
import com.groupdocs.cloud.parser.client.ProgressResponseBody;
import com.groupdocs.cloud.parser.model.FilesUploadResult;
import com.groupdocs.cloud.parser.model.requests.CopyFileRequest;
import com.groupdocs.cloud.parser.model.requests.DeleteFileRequest;
import com.groupdocs.cloud.parser.model.requests.DownloadFileRequest;
import com.groupdocs.cloud.parser.model.requests.MoveFileRequest;
import com.groupdocs.cloud.parser.model.requests.UploadFileRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class FileApi {
    private ApiClient apiClient;

    public FileApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public FileApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call copyFileCall(CopyFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/parser/storage/file/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getsrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getdestPath() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("destPath", request.getdestPath()));
        }
        if (request.getsrcStorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("srcStorageName", request.getsrcStorageName()));
        }
        if (request.getdestStorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("destStorageName", request.getdestStorageName()));
        }
        if (request.getversionId() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versionId", request.getversionId()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyFileValidateBeforeCall(CopyFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsrcPath() == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling copyFile(Async)");
        }
        if (request.getdestPath() == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling copyFile(Async)");
        }
        Call call = this.copyFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void copyFile(CopyFileRequest request) throws ApiException {
        this.copyFileWithHttpInfo(request);
    }

    public ApiResponse<Void> copyFileWithHttpInfo(CopyFileRequest request) throws ApiException {
        Call call = this.copyFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFileAsync(CopyFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteFileCall(DeleteFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/parser/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getstorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storageName", request.getstorageName()));
        }
        if (request.getversionId() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versionId", request.getversionId()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFileValidateBeforeCall(DeleteFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException("Missing the required parameter 'path' when calling deleteFile(Async)");
        }
        Call call = this.deleteFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFile(DeleteFileRequest request) throws ApiException {
        this.deleteFileWithHttpInfo(request);
    }

    public ApiResponse<Void> deleteFileWithHttpInfo(DeleteFileRequest request) throws ApiException {
        Call call = this.deleteFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFileAsync(DeleteFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call downloadFileCall(DownloadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/parser/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getstorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storageName", request.getstorageName()));
        }
        if (request.getversionId() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versionId", request.getversionId()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"multipart/form-data"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadFileValidateBeforeCall(DownloadFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException("Missing the required parameter 'path' when calling downloadFile(Async)");
        }
        Call call = this.downloadFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File downloadFile(DownloadFileRequest request) throws ApiException {
        ApiResponse<File> resp = this.downloadFileWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> downloadFileWithHttpInfo(DownloadFileRequest request) throws ApiException {
        Call call = this.downloadFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadFileAsync(DownloadFileRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call moveFileCall(MoveFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/parser/storage/file/move/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getsrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getdestPath() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("destPath", request.getdestPath()));
        }
        if (request.getsrcStorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("srcStorageName", request.getsrcStorageName()));
        }
        if (request.getdestStorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("destStorageName", request.getdestStorageName()));
        }
        if (request.getversionId() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versionId", request.getversionId()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveFileValidateBeforeCall(MoveFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsrcPath() == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling moveFile(Async)");
        }
        if (request.getdestPath() == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling moveFile(Async)");
        }
        Call call = this.moveFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void moveFile(MoveFileRequest request) throws ApiException {
        this.moveFileWithHttpInfo(request);
    }

    public ApiResponse<Void> moveFileWithHttpInfo(MoveFileRequest request) throws ApiException {
        Call call = this.moveFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call moveFileAsync(MoveFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call uploadFileCall(UploadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/parser/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getpath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getstorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storageName", request.getstorageName()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (request.getFile() != null) {
            localVarFormParams.put("File", request.getFile());
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadFileValidateBeforeCall(UploadFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpath() == null) {
            throw new ApiException("Missing the required parameter 'path' when calling uploadFile(Async)");
        }
        if (request.getFile() == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadFile(Async)");
        }
        Call call = this.uploadFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FilesUploadResult uploadFile(UploadFileRequest request) throws ApiException {
        ApiResponse<FilesUploadResult> resp = this.uploadFileWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<FilesUploadResult> uploadFileWithHttpInfo(UploadFileRequest request) throws ApiException {
        Call call = this.uploadFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FilesUploadResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadFileAsync(UploadFileRequest request, final ApiCallback<FilesUploadResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FilesUploadResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

