/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Class for rectangle coordinates.")
public class Coordinates {
    @SerializedName(value="top")
    private Double top = null;
    @SerializedName(value="bottom")
    private Double bottom = null;
    @SerializedName(value="left")
    private Double left = null;
    @SerializedName(value="right")
    private Double right = null;

    public Coordinates top(Double top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the y-coordinate of the top edge of the rectangular area.")
    public Double getTop() {
        return this.top;
    }

    public void setTop(Double top) {
        this.top = top;
    }

    public Coordinates bottom(Double bottom) {
        this.bottom = bottom;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the y-coordinate of the bottom edge of the rectangular area.")
    public Double getBottom() {
        return this.bottom;
    }

    public void setBottom(Double bottom) {
        this.bottom = bottom;
    }

    public Coordinates left(Double left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the x-coordinate of the left edge of the rectangular area.")
    public Double getLeft() {
        return this.left;
    }

    public void setLeft(Double left) {
        this.left = left;
    }

    public Coordinates right(Double right) {
        this.right = right;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the x-coordinate of the right edge of the rectangular area.")
    public Double getRight() {
        return this.right;
    }

    public void setRight(Double right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates coordinates = (Coordinates)o;
        return Objects.equals(this.top, coordinates.top) && Objects.equals(this.bottom, coordinates.bottom) && Objects.equals(this.left, coordinates.left) && Objects.equals(this.right, coordinates.right);
    }

    public int hashCode() {
        return Objects.hash(this.top, this.bottom, this.left, this.right);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Coordinates {\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    bottom: ").append(this.toIndentedString(this.bottom)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    right: ").append(this.toIndentedString(this.right)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

