/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.Rectangle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides parameters for the table detection algorithms. ")
public class DetectorParameters {
    @SerializedName(value="minRowCount")
    private Integer minRowCount = null;
    @SerializedName(value="minColumnCount")
    private Integer minColumnCount = null;
    @SerializedName(value="minVerticalSpace")
    private Integer minVerticalSpace = null;
    @SerializedName(value="hasMergedCells")
    private Boolean hasMergedCells = null;
    @SerializedName(value="rectangle")
    private Rectangle rectangle = null;
    @SerializedName(value="verticalSeparators")
    private List<Double> verticalSeparators = null;

    public DetectorParameters minRowCount(Integer minRowCount) {
        this.minRowCount = minRowCount;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the minimum number of the table rows.")
    public Integer getMinRowCount() {
        return this.minRowCount;
    }

    public void setMinRowCount(Integer minRowCount) {
        this.minRowCount = minRowCount;
    }

    public DetectorParameters minColumnCount(Integer minColumnCount) {
        this.minColumnCount = minColumnCount;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the minimum number of the table columns.")
    public Integer getMinColumnCount() {
        return this.minColumnCount;
    }

    public void setMinColumnCount(Integer minColumnCount) {
        this.minColumnCount = minColumnCount;
    }

    public DetectorParameters minVerticalSpace(Integer minVerticalSpace) {
        this.minVerticalSpace = minVerticalSpace;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the minimum space between the table columns.")
    public Integer getMinVerticalSpace() {
        return this.minVerticalSpace;
    }

    public void setMinVerticalSpace(Integer minVerticalSpace) {
        this.minVerticalSpace = minVerticalSpace;
    }

    public DetectorParameters hasMergedCells(Boolean hasMergedCells) {
        this.hasMergedCells = hasMergedCells;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the value that indicates whether the table has merged cells.")
    public Boolean getHasMergedCells() {
        return this.hasMergedCells;
    }

    public void setHasMergedCells(Boolean hasMergedCells) {
        this.hasMergedCells = hasMergedCells;
    }

    public DetectorParameters rectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the rectangular area that contains the table.")
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public DetectorParameters verticalSeparators(List<Double> verticalSeparators) {
        this.verticalSeparators = verticalSeparators;
        return this;
    }

    public DetectorParameters addVerticalSeparatorsItem(Double verticalSeparatorsItem) {
        if (this.verticalSeparators == null) {
            this.verticalSeparators = new ArrayList<Double>();
        }
        this.verticalSeparators.add(verticalSeparatorsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table columns separators.")
    public List<Double> getVerticalSeparators() {
        return this.verticalSeparators;
    }

    public void setVerticalSeparators(List<Double> verticalSeparators) {
        this.verticalSeparators = verticalSeparators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectorParameters detectorParameters = (DetectorParameters)o;
        return Objects.equals(this.minRowCount, detectorParameters.minRowCount) && Objects.equals(this.minColumnCount, detectorParameters.minColumnCount) && Objects.equals(this.minVerticalSpace, detectorParameters.minVerticalSpace) && Objects.equals(this.hasMergedCells, detectorParameters.hasMergedCells) && Objects.equals(this.rectangle, detectorParameters.rectangle) && Objects.equals(this.verticalSeparators, detectorParameters.verticalSeparators);
    }

    public int hashCode() {
        return Objects.hash(this.minRowCount, this.minColumnCount, this.minVerticalSpace, this.hasMergedCells, this.rectangle, this.verticalSeparators);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetectorParameters {\n");
        sb.append("    minRowCount: ").append(this.toIndentedString(this.minRowCount)).append("\n");
        sb.append("    minColumnCount: ").append(this.toIndentedString(this.minColumnCount)).append("\n");
        sb.append("    minVerticalSpace: ").append(this.toIndentedString(this.minVerticalSpace)).append("\n");
        sb.append("    hasMergedCells: ").append(this.toIndentedString(this.hasMergedCells)).append("\n");
        sb.append("    rectangle: ").append(this.toIndentedString(this.rectangle)).append("\n");
        sb.append("    verticalSeparators: ").append(this.toIndentedString(this.verticalSeparators)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

