/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.Image;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents page object with image collection.")
public class ImagePage {
    @SerializedName(value="pageIndex")
    private Integer pageIndex = null;
    @SerializedName(value="images")
    private List<Image> images = null;

    public ImagePage pageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    @ApiModelProperty(required=true, value="The index of the page.")
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public ImagePage images(List<Image> images) {
        this.images = images;
        return this;
    }

    public ImagePage addImagesItem(Image imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @ApiModelProperty(value="collection of the page images.")
    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImagePage imagePage = (ImagePage)o;
        return Objects.equals(this.pageIndex, imagePage.pageIndex) && Objects.equals(this.images, imagePage.images);
    }

    public int hashCode() {
        return Objects.hash(this.pageIndex, this.images);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImagePage {\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.pageIndex)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

