/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.Page;
import com.groupdocs.cloud.parser.model.PageTableArea;
import com.groupdocs.cloud.parser.model.PageTextArea;
import com.groupdocs.cloud.parser.model.Rectangle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Class for document page area.")
public class PageArea {
    @SerializedName(value="rectangle")
    private Rectangle rectangle = null;
    @SerializedName(value="page")
    private Page page = null;
    @SerializedName(value="pageTextArea")
    private PageTextArea pageTextArea = null;
    @SerializedName(value="pageTableArea")
    private PageTableArea pageTableArea = null;

    public PageArea rectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the rectangular area.")
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public PageArea page(Page page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the document page information such as page index and page size.")
    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public PageArea pageTextArea(PageTextArea pageTextArea) {
        this.pageTextArea = pageTextArea;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text area. Represents a page text area which is used to represent a text value in the parsing by template functionality.")
    public PageTextArea getPageTextArea() {
        return this.pageTextArea;
    }

    public void setPageTextArea(PageTextArea pageTextArea) {
        this.pageTextArea = pageTextArea;
    }

    public PageArea pageTableArea(PageTableArea pageTableArea) {
        this.pageTableArea = pageTableArea;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table area. Represents a table page area which is used to represent a table in the parsing by template functionality.")
    public PageTableArea getPageTableArea() {
        return this.pageTableArea;
    }

    public void setPageTableArea(PageTableArea pageTableArea) {
        this.pageTableArea = pageTableArea;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageArea pageArea = (PageArea)o;
        return Objects.equals(this.rectangle, pageArea.rectangle) && Objects.equals(this.page, pageArea.page) && Objects.equals(this.pageTextArea, pageArea.pageTextArea) && Objects.equals(this.pageTableArea, pageArea.pageTableArea);
    }

    public int hashCode() {
        return Objects.hash(this.rectangle, this.page, this.pageTextArea, this.pageTableArea);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageArea {\n");
        sb.append("    rectangle: ").append(this.toIndentedString(this.rectangle)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageTextArea: ").append(this.toIndentedString(this.pageTextArea)).append("\n");
        sb.append("    pageTableArea: ").append(this.toIndentedString(this.pageTableArea)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

