/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.TextStyle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a page text area which is used to represent a text value in the parsing by template functionality.")
public class PageTextArea {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="baseLine")
    private Double baseLine = null;
    @SerializedName(value="areas")
    private List<PageTextArea> areas = null;
    @SerializedName(value="textStyle")
    private TextStyle textStyle = null;

    public PageTextArea text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public PageTextArea baseLine(Double baseLine) {
        this.baseLine = baseLine;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the base line.")
    public Double getBaseLine() {
        return this.baseLine;
    }

    public void setBaseLine(Double baseLine) {
        this.baseLine = baseLine;
    }

    public PageTextArea areas(List<PageTextArea> areas) {
        this.areas = areas;
        return this;
    }

    public PageTextArea addAreasItem(PageTextArea areasItem) {
        if (this.areas == null) {
            this.areas = new ArrayList<PageTextArea>();
        }
        this.areas.add(areasItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the collection of child text page areas.")
    public List<PageTextArea> getAreas() {
        return this.areas;
    }

    public void setAreas(List<PageTextArea> areas) {
        this.areas = areas;
    }

    public PageTextArea textStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text style such as font size, font name an so on.")
    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageTextArea pageTextArea = (PageTextArea)o;
        return Objects.equals(this.text, pageTextArea.text) && Objects.equals(this.baseLine, pageTextArea.baseLine) && Objects.equals(this.areas, pageTextArea.areas) && Objects.equals(this.textStyle, pageTextArea.textStyle);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.baseLine, this.areas, this.textStyle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageTextArea {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    baseLine: ").append(this.toIndentedString(this.baseLine)).append("\n");
        sb.append("    areas: ").append(this.toIndentedString(this.areas)).append("\n");
        sb.append("    textStyle: ").append(this.toIndentedString(this.textStyle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

