/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.parser.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.parser.model.Coordinates;
import com.groupdocs.cloud.parser.model.Point;
import com.groupdocs.cloud.parser.model.Size;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Rectangular area on the page.")
public class Rectangle {
    @SerializedName(value="position")
    private Point position = null;
    @SerializedName(value="size")
    private Size size = null;
    @SerializedName(value="coordinates")
    private Coordinates coordinates = null;

    public Rectangle position(Point position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="Gets the coordinates of the upper-left corner of the rectangular area.")
    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Rectangle size(Size size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the size of the rectangle.")
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public Rectangle coordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the coordinates.")
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        return Objects.equals(this.position, rectangle.position) && Objects.equals(this.size, rectangle.size) && Objects.equals(this.coordinates, rectangle.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.size, this.coordinates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rectangle {\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

