/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.model.BaseTextRequest;
import com.groupdocs.model.CloudTextRequest;
import com.groupdocs.model.CompareTextRequest;
import com.groupdocs.model.CompareTextResponse;
import com.groupdocs.model.DetectionFileRequest;
import com.groupdocs.model.DetectionFileResponse;
import com.groupdocs.model.DetectionOcrRequest;
import com.groupdocs.model.DetectionTextRequest;
import com.groupdocs.model.DetectionTextResponse;
import com.groupdocs.model.DetectionTrialFileRequest;
import com.groupdocs.model.EstimateRequest;
import com.groupdocs.model.EstimateResponse;
import com.groupdocs.model.FormalizeFileRequest;
import com.groupdocs.model.FormalizeFileResponse;
import com.groupdocs.model.FormalizeOcrRequest;
import com.groupdocs.model.FormalizeTextRequest;
import com.groupdocs.model.FormalizeTextResponse;
import com.groupdocs.model.GenerateKeywordsRequest;
import com.groupdocs.model.GenerateRequest;
import com.groupdocs.model.GenerateResponse;
import com.groupdocs.model.GenerateVideoDescriptionRequest;
import com.groupdocs.model.HealthCheckInfo;
import com.groupdocs.model.HealthCheckResponse;
import com.groupdocs.model.LanguageInfo;
import com.groupdocs.model.Model;
import com.groupdocs.model.Opt;
import com.groupdocs.model.ParaphraseFileRequest;
import com.groupdocs.model.ParaphraseFileResponse;
import com.groupdocs.model.ParaphraseOcrRequest;
import com.groupdocs.model.ParaphraseTextRequest;
import com.groupdocs.model.ParaphraseTextResponse;
import com.groupdocs.model.ParaphraseTrialFileRequest;
import com.groupdocs.model.SimplifyFileRequest;
import com.groupdocs.model.SimplifyFileResponse;
import com.groupdocs.model.SimplifyOcrRequest;
import com.groupdocs.model.SimplifyTextResponse;
import com.groupdocs.model.SimplifyTrialFileRequest;
import com.groupdocs.model.StatusResponse;
import com.groupdocs.model.SummarizationFileRequest;
import com.groupdocs.model.SummarizationFileResponse;
import com.groupdocs.model.SummarizationMediaRequest;
import com.groupdocs.model.SummarizationOcrRequest;
import com.groupdocs.model.SummarizationTextRequest;
import com.groupdocs.model.SummarizationTextResponse;
import com.groupdocs.model.SummarizationTrialFileRequest;
import com.groupdocs.model.SynonymizeFileRequest;
import com.groupdocs.model.SynonymizeOcrRequest;
import com.groupdocs.model.SynonymizeTextRequest;
import com.groupdocs.model.SynonymizeTextResponse;
import com.groupdocs.model.Tokenizer;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Map;
import okio.ByteString;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            }
            return gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static <T> T deserialize(InputStream inputStream2, Type returnType) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream2, StandardCharsets.UTF_8);){
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(reader);
                jsonReader.setLenient(true);
                Object t = gson.fromJson(jsonReader, returnType);
                return t;
            }
            Object t = gson.fromJson((Reader)reader, returnType);
            return t;
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter((Type)((Object)java.util.Date.class), dateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)byte[].class), byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new BaseTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CloudTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CompareTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CompareTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DetectionFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DetectionFileResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DetectionOcrRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DetectionTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DetectionTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DetectionTrialFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EstimateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EstimateResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FormalizeFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FormalizeFileResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FormalizeOcrRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FormalizeTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FormalizeTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenerateKeywordsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenerateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenerateResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenerateVideoDescriptionRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HealthCheckInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HealthCheckResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new LanguageInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Model.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Opt.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ParaphraseFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ParaphraseFileResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ParaphraseOcrRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ParaphraseTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ParaphraseTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ParaphraseTrialFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SimplifyFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SimplifyFileResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SimplifyOcrRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SimplifyTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SimplifyTrialFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new StatusResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationFileResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationMediaRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationOcrRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SummarizationTrialFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SynonymizeFileRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SynonymizeOcrRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SynonymizeTextRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SynonymizeTextResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Tokenizer.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format(date, true);
                out.value(value);
            }
        }

        @Override
        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse(date, new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException(e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

