/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum DegreeEnum {
    OFF("Off"),
    MEDIUM("Medium"),
    HIGH("High");

    private String value;

    private DegreeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DegreeEnum fromValue(String value) {
        for (DegreeEnum b : DegreeEnum.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        DegreeEnum.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<DegreeEnum> {
        @Override
        public void write(JsonWriter jsonWriter, DegreeEnum enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public DegreeEnum read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return DegreeEnum.fromValue(value);
        }
    }
}

