/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import com.groupdocs.model.DetectionSupportedFormats;
import com.groupdocs.model.FileSavingMode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DetectionFileRequest {
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    @Nonnull
    private String language;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nullable
    private String url;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_ORIGINAL_NAME = "originalName";
    @SerializedName(value="originalName")
    @Nullable
    private String originalName;
    public static final String SERIALIZED_NAME_SAVING_MODE = "savingMode";
    @SerializedName(value="savingMode")
    @Nullable
    private FileSavingMode savingMode;
    public static final String SERIALIZED_NAME_MIN_LENGTH = "minLength";
    @SerializedName(value="minLength")
    @Nullable
    private Integer minLength;
    public static final String SERIALIZED_NAME_DETECT_LANGUAGE = "detectLanguage";
    @SerializedName(value="detectLanguage")
    @Nullable
    private Boolean detectLanguage;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    @Nullable
    private DetectionSupportedFormats format;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("language", "url", "origin", "originalName", "savingMode", "minLength", "detectLanguage", "format"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("language"));

    public DetectionFileRequest language(@Nonnull String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@Nonnull String language) {
        this.language = language;
    }

    public DetectionFileRequest url(@Nullable String url) {
        this.url = url;
        return this;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public DetectionFileRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public DetectionFileRequest originalName(@Nullable String originalName) {
        this.originalName = originalName;
        return this;
    }

    @Nullable
    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(@Nullable String originalName) {
        this.originalName = originalName;
    }

    public DetectionFileRequest savingMode(@Nullable FileSavingMode savingMode) {
        this.savingMode = savingMode;
        return this;
    }

    @Nullable
    public FileSavingMode getSavingMode() {
        return this.savingMode;
    }

    public void setSavingMode(@Nullable FileSavingMode savingMode) {
        this.savingMode = savingMode;
    }

    public DetectionFileRequest minLength(@Nullable Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(@Nullable Integer minLength) {
        this.minLength = minLength;
    }

    public DetectionFileRequest detectLanguage(@Nullable Boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
        return this;
    }

    @Nullable
    public Boolean getDetectLanguage() {
        return this.detectLanguage;
    }

    public void setDetectLanguage(@Nullable Boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
    }

    public DetectionFileRequest format(@Nullable DetectionSupportedFormats format) {
        this.format = format;
        return this;
    }

    @Nullable
    public DetectionSupportedFormats getFormat() {
        return this.format;
    }

    public void setFormat(@Nullable DetectionSupportedFormats format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectionFileRequest detectionFileRequest = (DetectionFileRequest)o;
        return Objects.equals(this.language, detectionFileRequest.language) && Objects.equals(this.url, detectionFileRequest.url) && Objects.equals(this.origin, detectionFileRequest.origin) && Objects.equals(this.originalName, detectionFileRequest.originalName) && Objects.equals((Object)this.savingMode, (Object)detectionFileRequest.savingMode) && Objects.equals(this.minLength, detectionFileRequest.minLength) && Objects.equals(this.detectLanguage, detectionFileRequest.detectLanguage) && Objects.equals((Object)this.format, (Object)detectionFileRequest.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.url, this.origin, this.originalName, this.savingMode, this.minLength, this.detectLanguage, this.format});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetectionFileRequest {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    originalName: ").append(this.toIndentedString(this.originalName)).append("\n");
        sb.append("    savingMode: ").append(this.toIndentedString((Object)this.savingMode)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    detectLanguage: ").append(this.toIndentedString(this.detectLanguage)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DetectionFileRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DetectionFileRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull()) {
            FileSavingMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SAVING_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull()) {
            DetectionSupportedFormats.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FORMAT));
        }
    }

    public static DetectionFileRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, DetectionFileRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DetectionFileRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<DetectionFileRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(DetectionFileRequest.class));
            return new TypeAdapter<DetectionFileRequest>(){

                @Override
                public void write(JsonWriter out, DetectionFileRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public DetectionFileRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DetectionFileRequest.validateJsonElement(jsonElement);
                    return (DetectionFileRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

