/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum DetectionSupportedFormats {
    UNKNOWN("Unknown"),
    DOC("Doc"),
    DOCX("Docx"),
    DOCM("Docm"),
    RTF("Rtf"),
    ODT("Odt"),
    TXT("Txt"),
    PDF("Pdf");

    private String value;

    private DetectionSupportedFormats(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetectionSupportedFormats fromValue(String value) {
        for (DetectionSupportedFormats b : DetectionSupportedFormats.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        DetectionSupportedFormats.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<DetectionSupportedFormats> {
        @Override
        public void write(JsonWriter jsonWriter, DetectionSupportedFormats enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public DetectionSupportedFormats read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return DetectionSupportedFormats.fromValue(value);
        }
    }
}

