/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum HttpStatusCode {
    CONTINUE("Continue"),
    SWITCHING_PROTOCOLS("SwitchingProtocols"),
    PROCESSING("Processing"),
    EARLY_HINTS("EarlyHints"),
    OK("OK"),
    CREATED("Created"),
    ACCEPTED("Accepted"),
    NON_AUTHORITATIVE_INFORMATION("NonAuthoritativeInformation"),
    NO_CONTENT("NoContent"),
    RESET_CONTENT("ResetContent"),
    PARTIAL_CONTENT("PartialContent"),
    MULTI_STATUS("MultiStatus"),
    ALREADY_REPORTED("AlreadyReported"),
    IM_USED("IMUsed"),
    MULTIPLE_CHOICES("MultipleChoices"),
    MOVED_PERMANENTLY("MovedPermanently"),
    FOUND("Found"),
    SEE_OTHER("SeeOther"),
    NOT_MODIFIED("NotModified"),
    USE_PROXY("UseProxy"),
    UNUSED("Unused"),
    TEMPORARY_REDIRECT("TemporaryRedirect"),
    PERMANENT_REDIRECT("PermanentRedirect"),
    BAD_REQUEST("BadRequest"),
    UNAUTHORIZED("Unauthorized"),
    PAYMENT_REQUIRED("PaymentRequired"),
    FORBIDDEN("Forbidden"),
    NOT_FOUND("NotFound"),
    METHOD_NOT_ALLOWED("MethodNotAllowed"),
    NOT_ACCEPTABLE("NotAcceptable"),
    PROXY_AUTHENTICATION_REQUIRED("ProxyAuthenticationRequired"),
    REQUEST_TIMEOUT("RequestTimeout"),
    CONFLICT("Conflict"),
    GONE("Gone"),
    LENGTH_REQUIRED("LengthRequired"),
    PRECONDITION_FAILED("PreconditionFailed"),
    REQUEST_ENTITY_TOO_LARGE("RequestEntityTooLarge"),
    REQUEST_URI_TOO_LONG("RequestUriTooLong"),
    UNSUPPORTED_MEDIA_TYPE("UnsupportedMediaType"),
    REQUESTED_RANGE_NOT_SATISFIABLE("RequestedRangeNotSatisfiable"),
    EXPECTATION_FAILED("ExpectationFailed"),
    MISDIRECTED_REQUEST("MisdirectedRequest"),
    UNPROCESSABLE_ENTITY("UnprocessableEntity"),
    LOCKED("Locked"),
    FAILED_DEPENDENCY("FailedDependency"),
    UPGRADE_REQUIRED("UpgradeRequired"),
    PRECONDITION_REQUIRED("PreconditionRequired"),
    TOO_MANY_REQUESTS("TooManyRequests"),
    REQUEST_HEADER_FIELDS_TOO_LARGE("RequestHeaderFieldsTooLarge"),
    UNAVAILABLE_FOR_LEGAL_REASONS("UnavailableForLegalReasons"),
    INTERNAL_SERVER_ERROR("InternalServerError"),
    NOT_IMPLEMENTED("NotImplemented"),
    BAD_GATEWAY("BadGateway"),
    SERVICE_UNAVAILABLE("ServiceUnavailable"),
    GATEWAY_TIMEOUT("GatewayTimeout"),
    HTTP_VERSION_NOT_SUPPORTED("HttpVersionNotSupported"),
    VARIANT_ALSO_NEGOTIATES("VariantAlsoNegotiates"),
    INSUFFICIENT_STORAGE("InsufficientStorage"),
    LOOP_DETECTED("LoopDetected"),
    NOT_EXTENDED("NotExtended"),
    NETWORK_AUTHENTICATION_REQUIRED("NetworkAuthenticationRequired");

    private String value;

    private HttpStatusCode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpStatusCode fromValue(String value) {
        for (HttpStatusCode b : HttpStatusCode.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        HttpStatusCode.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<HttpStatusCode> {
        @Override
        public void write(JsonWriter jsonWriter, HttpStatusCode enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public HttpStatusCode read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return HttpStatusCode.fromValue(value);
        }
    }
}

