/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum MediaInputFormat {
    UNKNOWN("Unknown"),
    MP3("Mp3"),
    WAV("Wav"),
    FLAC("Flac"),
    M4A("M4a"),
    AAC("Aac"),
    WMA("Wma"),
    FLV("Flv"),
    MKV("Mkv"),
    WEBM("Webm"),
    AVI("Avi"),
    MOV("Mov"),
    WMV("Wmv"),
    RM("Rm"),
    MPG("Mpg");

    private String value;

    private MediaInputFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaInputFormat fromValue(String value) {
        for (MediaInputFormat b : MediaInputFormat.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        MediaInputFormat.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<MediaInputFormat> {
        @Override
        public void write(JsonWriter jsonWriter, MediaInputFormat enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public MediaInputFormat read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return MediaInputFormat.fromValue(value);
        }
    }
}

