/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum OcrInputFormat {
    UNKNOWN("Unknown"),
    BMP("Bmp"),
    JPG("Jpg"),
    PNG("Png"),
    SVG("Svg"),
    GIF("Gif"),
    PDF("Pdf");

    private String value;

    private OcrInputFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcrInputFormat fromValue(String value) {
        for (OcrInputFormat b : OcrInputFormat.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        OcrInputFormat.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<OcrInputFormat> {
        @Override
        public void write(JsonWriter jsonWriter, OcrInputFormat enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public OcrInputFormat read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OcrInputFormat.fromValue(value);
        }
    }
}

