/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum OcrOutputFormat {
    TEXT("Text"),
    PDF("Pdf");

    private String value;

    private OcrOutputFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcrOutputFormat fromValue(String value) {
        for (OcrOutputFormat b : OcrOutputFormat.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        OcrOutputFormat.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<OcrOutputFormat> {
        @Override
        public void write(JsonWriter jsonWriter, OcrOutputFormat enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public OcrOutputFormat read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OcrOutputFormat.fromValue(value);
        }
    }
}

