/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import com.groupdocs.model.FileSavingMode;
import com.groupdocs.model.SimplifySupportedFromats;
import com.groupdocs.model.SupportedConversionsFormats;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimplifyFileRequest {
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    @Nonnull
    private String language;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    @Nullable
    private String url;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_ORIGINAL_NAME = "originalName";
    @SerializedName(value="originalName")
    @Nullable
    private String originalName;
    public static final String SERIALIZED_NAME_SAVING_MODE = "savingMode";
    @SerializedName(value="savingMode")
    @Nullable
    private FileSavingMode savingMode;
    public static final String SERIALIZED_NAME_OUTPUT_FORMAT = "outputFormat";
    @SerializedName(value="outputFormat")
    @Nonnull
    private SupportedConversionsFormats outputFormat;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    @Nullable
    private SimplifySupportedFromats format;
    public static final String SERIALIZED_NAME_DETECT_LANGUAGE = "detectLanguage";
    @SerializedName(value="detectLanguage")
    @Nullable
    private Boolean detectLanguage;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("language", "url", "origin", "originalName", "savingMode", "outputFormat", "format", "detectLanguage"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("language", "outputFormat"));

    public SimplifyFileRequest language(@Nonnull String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@Nonnull String language) {
        this.language = language;
    }

    public SimplifyFileRequest url(@Nullable String url) {
        this.url = url;
        return this;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public SimplifyFileRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public SimplifyFileRequest originalName(@Nullable String originalName) {
        this.originalName = originalName;
        return this;
    }

    @Nullable
    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(@Nullable String originalName) {
        this.originalName = originalName;
    }

    public SimplifyFileRequest savingMode(@Nullable FileSavingMode savingMode) {
        this.savingMode = savingMode;
        return this;
    }

    @Nullable
    public FileSavingMode getSavingMode() {
        return this.savingMode;
    }

    public void setSavingMode(@Nullable FileSavingMode savingMode) {
        this.savingMode = savingMode;
    }

    public SimplifyFileRequest outputFormat(@Nonnull SupportedConversionsFormats outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Nonnull
    public SupportedConversionsFormats getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(@Nonnull SupportedConversionsFormats outputFormat) {
        this.outputFormat = outputFormat;
    }

    public SimplifyFileRequest format(@Nullable SimplifySupportedFromats format) {
        this.format = format;
        return this;
    }

    @Nullable
    public SimplifySupportedFromats getFormat() {
        return this.format;
    }

    public void setFormat(@Nullable SimplifySupportedFromats format) {
        this.format = format;
    }

    public SimplifyFileRequest detectLanguage(@Nullable Boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
        return this;
    }

    @Nullable
    public Boolean getDetectLanguage() {
        return this.detectLanguage;
    }

    public void setDetectLanguage(@Nullable Boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplifyFileRequest simplifyFileRequest = (SimplifyFileRequest)o;
        return Objects.equals(this.language, simplifyFileRequest.language) && Objects.equals(this.url, simplifyFileRequest.url) && Objects.equals(this.origin, simplifyFileRequest.origin) && Objects.equals(this.originalName, simplifyFileRequest.originalName) && Objects.equals((Object)this.savingMode, (Object)simplifyFileRequest.savingMode) && Objects.equals((Object)this.outputFormat, (Object)simplifyFileRequest.outputFormat) && Objects.equals((Object)this.format, (Object)simplifyFileRequest.format) && Objects.equals(this.detectLanguage, simplifyFileRequest.detectLanguage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.url, this.origin, this.originalName, this.savingMode, this.outputFormat, this.format, this.detectLanguage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimplifyFileRequest {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    originalName: ").append(this.toIndentedString(this.originalName)).append("\n");
        sb.append("    savingMode: ").append(this.toIndentedString((Object)this.savingMode)).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString((Object)this.outputFormat)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    detectLanguage: ").append(this.toIndentedString(this.detectLanguage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SimplifyFileRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SimplifyFileRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAVING_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SAVING_MODE).isJsonNull()) {
            FileSavingMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SAVING_MODE));
        }
        SupportedConversionsFormats.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OUTPUT_FORMAT));
        if (jsonObj.get(SERIALIZED_NAME_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_FORMAT).isJsonNull()) {
            SimplifySupportedFromats.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FORMAT));
        }
    }

    public static SimplifyFileRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SimplifyFileRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SimplifyFileRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SimplifyFileRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SimplifyFileRequest.class));
            return new TypeAdapter<SimplifyFileRequest>(){

                @Override
                public void write(JsonWriter out, SimplifyFileRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public SimplifyFileRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SimplifyFileRequest.validateJsonElement(jsonElement);
                    return (SimplifyFileRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

