/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.JSON;
import com.groupdocs.model.DegreeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SummarizationTextRequest {
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    @Nonnull
    private String language;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    @Nullable
    private String text;
    public static final String SERIALIZED_NAME_TEXTS = "texts";
    @SerializedName(value="texts")
    @Nullable
    private List<String> texts = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    @Nullable
    private String origin;
    public static final String SERIALIZED_NAME_DETECT_LANGUAGE = "detectLanguage";
    @SerializedName(value="detectLanguage")
    @Nullable
    private Boolean detectLanguage;
    public static final String SERIALIZED_NAME_SUMMARIZATION_DEGREE = "summarizationDegree";
    @SerializedName(value="summarizationDegree")
    @Nullable
    private DegreeEnum summarizationDegree;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("language", "text", "texts", "origin", "detectLanguage", "summarizationDegree"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("language"));

    public SummarizationTextRequest language(@Nonnull String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@Nonnull String language) {
        this.language = language;
    }

    public SummarizationTextRequest text(@Nullable String text) {
        this.text = text;
        return this;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public void setText(@Nullable String text) {
        this.text = text;
    }

    public SummarizationTextRequest texts(@Nullable List<String> texts) {
        this.texts = texts;
        return this;
    }

    public SummarizationTextRequest addTextsItem(String textsItem) {
        if (this.texts == null) {
            this.texts = new ArrayList<String>();
        }
        this.texts.add(textsItem);
        return this;
    }

    @Nullable
    public List<String> getTexts() {
        return this.texts;
    }

    public void setTexts(@Nullable List<String> texts) {
        this.texts = texts;
    }

    public SummarizationTextRequest origin(@Nullable String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public SummarizationTextRequest detectLanguage(@Nullable Boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
        return this;
    }

    @Nullable
    public Boolean getDetectLanguage() {
        return this.detectLanguage;
    }

    public void setDetectLanguage(@Nullable Boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
    }

    public SummarizationTextRequest summarizationDegree(@Nullable DegreeEnum summarizationDegree) {
        this.summarizationDegree = summarizationDegree;
        return this;
    }

    @Nullable
    public DegreeEnum getSummarizationDegree() {
        return this.summarizationDegree;
    }

    public void setSummarizationDegree(@Nullable DegreeEnum summarizationDegree) {
        this.summarizationDegree = summarizationDegree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SummarizationTextRequest summarizationTextRequest = (SummarizationTextRequest)o;
        return Objects.equals(this.language, summarizationTextRequest.language) && Objects.equals(this.text, summarizationTextRequest.text) && Objects.equals(this.texts, summarizationTextRequest.texts) && Objects.equals(this.origin, summarizationTextRequest.origin) && Objects.equals(this.detectLanguage, summarizationTextRequest.detectLanguage) && Objects.equals((Object)this.summarizationDegree, (Object)summarizationTextRequest.summarizationDegree);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.text, this.texts, this.origin, this.detectLanguage, this.summarizationDegree});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SummarizationTextRequest {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    texts: ").append(this.toIndentedString(this.texts)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    detectLanguage: ").append(this.toIndentedString(this.detectLanguage)).append("\n");
        sb.append("    summarizationDegree: ").append(this.toIndentedString((Object)this.summarizationDegree)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SummarizationTextRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SummarizationTextRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXTS) != null && !jsonObj.get(SERIALIZED_NAME_TEXTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TEXTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `texts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUMMARIZATION_DEGREE) != null && !jsonObj.get(SERIALIZED_NAME_SUMMARIZATION_DEGREE).isJsonNull()) {
            DegreeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUMMARIZATION_DEGREE));
        }
    }

    public static SummarizationTextRequest fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SummarizationTextRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SummarizationTextRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SummarizationTextRequest> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SummarizationTextRequest.class));
            return new TypeAdapter<SummarizationTextRequest>(){

                @Override
                public void write(JsonWriter out, SummarizationTextRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public SummarizationTextRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SummarizationTextRequest.validateJsonElement(jsonElement);
                    return (SummarizationTextRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

