/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;

public final class ArgumentsProcessor {
    public static Object[] expandArgs(MockitoMethod method, Object[] args2) {
        int nParams = method.getParameterTypes().length;
        if (args2 != null && args2.length > nParams) {
            args2 = Arrays.copyOf(args2, nParams);
        }
        return ArgumentsProcessor.expandVarArgs(method.isVarArgs(), args2);
    }

    private static Object[] expandVarArgs(boolean isVarArgs, Object[] args2) {
        if (!isVarArgs || ArgumentsProcessor.isNullOrEmpty(args2) || args2[args2.length - 1] != null && !args2[args2.length - 1].getClass().isArray()) {
            return args2 == null ? new Object[]{} : args2;
        }
        int nonVarArgsCount = args2.length - 1;
        Object[] varArgs = args2[nonVarArgsCount] == null ? new Object[]{null} : ArrayEquals.createObjectArray(args2[nonVarArgsCount]);
        int varArgsCount = varArgs.length;
        Object[] newArgs = new Object[nonVarArgsCount + varArgsCount];
        System.arraycopy(args2, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    private static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static List<ArgumentMatcher> argumentsToMatchers(Object[] arguments) {
        ArrayList<ArgumentMatcher> matchers = new ArrayList<ArgumentMatcher>(arguments.length);
        for (Object arg : arguments) {
            if (arg != null && arg.getClass().isArray()) {
                matchers.add(new ArrayEquals(arg));
                continue;
            }
            matchers.add(new Equals(arg));
        }
        return matchers;
    }

    private ArgumentsProcessor() {
    }
}

