/**
 * --------------------------------------------------------------------------------------------------------------------
 * <copyright company="Aspose Pty Ltd" file="RadialGradientBrush.java">
 *   Copyright (c) Aspose Pty Ltd
 * </copyright>
 * <summary>
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 * </summary>
 * --------------------------------------------------------------------------------------------------------------------
 */

package com.groupdocs.cloud.signature.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.Brush;
import com.groupdocs.cloud.signature.model.Color;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Represents radial gradient brush
 */
@ApiModel(description = "Represents radial gradient brush")
public class RadialGradientBrush extends Brush {
  @SerializedName("innerColor")
  private Color innerColor = null;

  @SerializedName("outerColor")
  private Color outerColor = null;

  public RadialGradientBrush innerColor(Color innerColor) {
    this.innerColor = innerColor;
    return this;
  }

   /**
   * Gets or sets inner gradient color
   * @return innerColor
  **/
  @ApiModelProperty(value = "Gets or sets inner gradient color")
  public Color getInnerColor() {
    return innerColor;
  }

  public void setInnerColor(Color innerColor) {
    this.innerColor = innerColor;
  }

  public RadialGradientBrush outerColor(Color outerColor) {
    this.outerColor = outerColor;
    return this;
  }

   /**
   * Gets or sets outer gradient color
   * @return outerColor
  **/
  @ApiModelProperty(value = "Gets or sets outer gradient color")
  public Color getOuterColor() {
    return outerColor;
  }

  public void setOuterColor(Color outerColor) {
    this.outerColor = outerColor;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RadialGradientBrush radialGradientBrush = (RadialGradientBrush) o;
    return Objects.equals(this.innerColor, radialGradientBrush.innerColor) &&
        Objects.equals(this.outerColor, radialGradientBrush.outerColor) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(innerColor, outerColor, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RadialGradientBrush {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    innerColor: ").append(toIndentedString(innerColor)).append("\n");
    sb.append("    outerColor: ").append(toIndentedString(outerColor)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

