/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.signature.client.ApiCallback;
import com.groupdocs.cloud.signature.client.ApiClient;
import com.groupdocs.cloud.signature.client.ApiException;
import com.groupdocs.cloud.signature.client.ApiResponse;
import com.groupdocs.cloud.signature.client.Configuration;
import com.groupdocs.cloud.signature.client.Pair;
import com.groupdocs.cloud.signature.client.ProgressRequestBody;
import com.groupdocs.cloud.signature.client.ProgressResponseBody;
import com.groupdocs.cloud.signature.model.PreviewResult;
import com.groupdocs.cloud.signature.model.PreviewSettings;
import com.groupdocs.cloud.signature.model.requests.PreviewDocumentRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class PreviewApi {
    private ApiClient apiClient;

    public PreviewApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public PreviewApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call previewDocumentCall(PreviewDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PreviewSettings localVarPostBody = request.getpreviewSettings();
        String localVarPath = "/signature/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call previewDocumentValidateBeforeCall(PreviewDocumentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getpreviewSettings() == null) {
            throw new ApiException("Missing the required parameter 'previewSettings' when calling previewDocument(Async)");
        }
        Call call = this.previewDocumentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public PreviewResult previewDocument(PreviewDocumentRequest request) throws ApiException {
        ApiResponse<PreviewResult> resp = this.previewDocumentWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<PreviewResult> previewDocumentWithHttpInfo(PreviewDocumentRequest request) throws ApiException {
        Call call = this.previewDocumentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<PreviewResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call previewDocumentAsync(PreviewDocumentRequest request, final ApiCallback<PreviewResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.previewDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PreviewResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

