/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.signature.client.ApiCallback;
import com.groupdocs.cloud.signature.client.ApiClient;
import com.groupdocs.cloud.signature.client.ApiException;
import com.groupdocs.cloud.signature.client.ApiResponse;
import com.groupdocs.cloud.signature.client.Configuration;
import com.groupdocs.cloud.signature.client.Pair;
import com.groupdocs.cloud.signature.client.ProgressRequestBody;
import com.groupdocs.cloud.signature.client.ProgressResponseBody;
import com.groupdocs.cloud.signature.model.DeleteResult;
import com.groupdocs.cloud.signature.model.DeleteSettings;
import com.groupdocs.cloud.signature.model.SearchResult;
import com.groupdocs.cloud.signature.model.SearchSettings;
import com.groupdocs.cloud.signature.model.SignResult;
import com.groupdocs.cloud.signature.model.SignSettings;
import com.groupdocs.cloud.signature.model.UpdateResult;
import com.groupdocs.cloud.signature.model.UpdateSettings;
import com.groupdocs.cloud.signature.model.VerifyResult;
import com.groupdocs.cloud.signature.model.VerifySettings;
import com.groupdocs.cloud.signature.model.requests.CreateSignaturesRequest;
import com.groupdocs.cloud.signature.model.requests.DeleteSignaturesRequest;
import com.groupdocs.cloud.signature.model.requests.SearchSignaturesRequest;
import com.groupdocs.cloud.signature.model.requests.UpdateSignaturesRequest;
import com.groupdocs.cloud.signature.model.requests.VerifySignaturesRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SignApi {
    private ApiClient apiClient;

    public SignApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public SignApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createSignaturesCall(CreateSignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SignSettings localVarPostBody = request.getsignSettings();
        String localVarPath = "/signature/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSignaturesValidateBeforeCall(CreateSignaturesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsignSettings() == null) {
            throw new ApiException("Missing the required parameter 'signSettings' when calling createSignatures(Async)");
        }
        Call call = this.createSignaturesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public SignResult createSignatures(CreateSignaturesRequest request) throws ApiException {
        ApiResponse<SignResult> resp = this.createSignaturesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<SignResult> createSignaturesWithHttpInfo(CreateSignaturesRequest request) throws ApiException {
        Call call = this.createSignaturesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<SignResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSignaturesAsync(CreateSignaturesRequest request, final ApiCallback<SignResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSignaturesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SignResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSignaturesCall(DeleteSignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeleteSettings localVarPostBody = request.getdeleteSettings();
        String localVarPath = "/signature/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSignaturesValidateBeforeCall(DeleteSignaturesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getdeleteSettings() == null) {
            throw new ApiException("Missing the required parameter 'deleteSettings' when calling deleteSignatures(Async)");
        }
        Call call = this.deleteSignaturesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DeleteResult deleteSignatures(DeleteSignaturesRequest request) throws ApiException {
        ApiResponse<DeleteResult> resp = this.deleteSignaturesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DeleteResult> deleteSignaturesWithHttpInfo(DeleteSignaturesRequest request) throws ApiException {
        Call call = this.deleteSignaturesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DeleteResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSignaturesAsync(DeleteSignaturesRequest request, final ApiCallback<DeleteResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSignaturesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchSignaturesCall(SearchSignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SearchSettings localVarPostBody = request.getsearchSettings();
        String localVarPath = "/signature/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchSignaturesValidateBeforeCall(SearchSignaturesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsearchSettings() == null) {
            throw new ApiException("Missing the required parameter 'searchSettings' when calling searchSignatures(Async)");
        }
        Call call = this.searchSignaturesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public SearchResult searchSignatures(SearchSignaturesRequest request) throws ApiException {
        ApiResponse<SearchResult> resp = this.searchSignaturesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<SearchResult> searchSignaturesWithHttpInfo(SearchSignaturesRequest request) throws ApiException {
        Call call = this.searchSignaturesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<SearchResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchSignaturesAsync(SearchSignaturesRequest request, final ApiCallback<SearchResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchSignaturesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SearchResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateSignaturesCall(UpdateSignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateSettings localVarPostBody = request.getupdateSettings();
        String localVarPath = "/signature/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateSignaturesValidateBeforeCall(UpdateSignaturesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getupdateSettings() == null) {
            throw new ApiException("Missing the required parameter 'updateSettings' when calling updateSignatures(Async)");
        }
        Call call = this.updateSignaturesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public UpdateResult updateSignatures(UpdateSignaturesRequest request) throws ApiException {
        ApiResponse<UpdateResult> resp = this.updateSignaturesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<UpdateResult> updateSignaturesWithHttpInfo(UpdateSignaturesRequest request) throws ApiException {
        Call call = this.updateSignaturesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<UpdateResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateSignaturesAsync(UpdateSignaturesRequest request, final ApiCallback<UpdateResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateSignaturesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdateResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call verifySignaturesCall(VerifySignaturesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        VerifySettings localVarPostBody = request.getverifySettings();
        String localVarPath = "/signature/verify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call verifySignaturesValidateBeforeCall(VerifySignaturesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getverifySettings() == null) {
            throw new ApiException("Missing the required parameter 'verifySettings' when calling verifySignatures(Async)");
        }
        Call call = this.verifySignaturesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public VerifyResult verifySignatures(VerifySignaturesRequest request) throws ApiException {
        ApiResponse<VerifyResult> resp = this.verifySignaturesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<VerifyResult> verifySignaturesWithHttpInfo(VerifySignaturesRequest request) throws ApiException {
        Call call = this.verifySignaturesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<VerifyResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call verifySignaturesAsync(VerifySignaturesRequest request, final ApiCallback<VerifyResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.verifySignaturesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VerifyResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

