/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.client;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.groupdocs.cloud.signature.model.BarcodeSignature;
import com.groupdocs.cloud.signature.model.CheckboxFormFieldSignature;
import com.groupdocs.cloud.signature.model.ComboboxFormFieldSignature;
import com.groupdocs.cloud.signature.model.DigitalFormFieldSignature;
import com.groupdocs.cloud.signature.model.DigitalSignature;
import com.groupdocs.cloud.signature.model.FormFieldSignature;
import com.groupdocs.cloud.signature.model.ImageSignature;
import com.groupdocs.cloud.signature.model.QRCodeSignature;
import com.groupdocs.cloud.signature.model.RadioButtonFormFieldSignature;
import com.groupdocs.cloud.signature.model.Signature;
import com.groupdocs.cloud.signature.model.TextFormFieldSignature;
import com.groupdocs.cloud.signature.model.TextSignature;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class SignatureDeserializer
implements JsonDeserializer<Signature> {
    Gson gson;
    Map<String, Class<? extends Signature>> registry;
    Map<String, Class<? extends Signature>> registryFf;

    SignatureDeserializer(Gson _gson) {
        this.gson = _gson;
        this.registry = new HashMap<String, Class<? extends Signature>>();
        this.registry.put("Barcode", BarcodeSignature.class);
        this.registry.put("QRCode", QRCodeSignature.class);
        this.registry.put("Digital", DigitalSignature.class);
        this.registry.put("Image", ImageSignature.class);
        this.registry.put("Text", TextSignature.class);
        this.registryFf = new HashMap<String, Class<? extends Signature>>();
        this.registryFf.put("Checkbox", CheckboxFormFieldSignature.class);
        this.registryFf.put("Text", TextFormFieldSignature.class);
        this.registryFf.put("Combobox", ComboboxFormFieldSignature.class);
        this.registryFf.put("DigitalSignature", DigitalFormFieldSignature.class);
        this.registryFf.put("Radio", RadioButtonFormFieldSignature.class);
    }

    public Signature deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject signatureObject = json.getAsJsonObject();
        JsonElement signatureTypeElement = signatureObject.get("signatureType");
        String signatureType = signatureTypeElement.getAsString();
        if (signatureType == "FormField") {
            JsonElement formFieldTypeElement = signatureObject.get("type");
            String formFieldType = formFieldTypeElement.getAsString();
            Class<? extends Signature> signatureInstanceClass = this.registryFf.get(signatureType);
            if (signatureInstanceClass == null) {
                signatureInstanceClass = FormFieldSignature.class;
            }
            return (Signature)this.gson.fromJson(json, signatureInstanceClass);
        }
        Class<? extends Signature> signatureInstanceClass = this.registry.get(signatureType);
        if (signatureInstanceClass == null) {
            signatureInstanceClass = Signature.class;
        }
        return (Signature)this.gson.fromJson(json, signatureInstanceClass);
    }
}

