/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.Color;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Instance to keep Border line properties")
public class BorderLine {
    @SerializedName(value="style")
    private StyleEnum style = null;
    @SerializedName(value="transparency")
    private Double transparency = null;
    @SerializedName(value="weight")
    private Double weight = null;
    @SerializedName(value="color")
    private Color color = null;
    @SerializedName(value="visible")
    private Boolean visible = null;

    public BorderLine style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the signature border style")
    public StyleEnum getStyle() {
        return this.style;
    }

    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public BorderLine transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the signature border transparency (value from 0.0 (opaque) through 1.0 (clear))")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public BorderLine weight(Double weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the weight of the signature border")
    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public BorderLine color(Color color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the border color of signature")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public BorderLine visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the border visibility")
    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderLine borderLine = (BorderLine)o;
        return Objects.equals((Object)this.style, (Object)borderLine.style) && Objects.equals(this.transparency, borderLine.transparency) && Objects.equals(this.weight, borderLine.weight) && Objects.equals(this.color, borderLine.color) && Objects.equals(this.visible, borderLine.visible);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.style, this.transparency, this.weight, this.color, this.visible});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BorderLine {\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StyleEnum {
        SOLID("Solid"),
        SHORTDASH("ShortDash"),
        SHORTDOT("ShortDot"),
        SHORTDASHDOT("ShortDashDot"),
        SHORTDASHDOTDOT("ShortDashDotDot"),
        DOT("Dot"),
        DASH("Dash"),
        LONGDASH("LongDash"),
        DASHDOT("DashDot"),
        LONGDASHDOT("LongDashDot"),
        LONGDASHDOTDOT("LongDashDotDot"),
        ROUNDDOT("RoundDot"),
        SQUAREDOT("SquareDot"),
        DASHDOTDOT("DashDotDot"),
        DASHLONGDASH("DashLongDash"),
        DASHLONGDASHDOT("DashLongDashDot");

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StyleEnum fromValue(String text) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StyleEnum> {
            public void write(JsonWriter jsonWriter, StyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StyleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

