/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Base container class for delete signature options")
public class DeleteOptions {
    @SerializedName(value="signatureType")
    private SignatureTypeEnum signatureType = null;
    @SerializedName(value="signatureId")
    private String signatureId = null;

    public DeleteOptions signatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the type of signature")
    public SignatureTypeEnum getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
    }

    public DeleteOptions signatureId(String signatureId) {
        this.signatureId = signatureId;
        return this;
    }

    @ApiModelProperty(value="Unique signature identifier to modify signature in the document over Update or Delete methods. This property will be set automatically after Sign or Search method being called. If this property was saved before it can be set manually to manipulate the signature.              ")
    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOptions deleteOptions = (DeleteOptions)o;
        return Objects.equals((Object)this.signatureType, (Object)deleteOptions.signatureType) && Objects.equals(this.signatureId, deleteOptions.signatureId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureType, this.signatureId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteOptions {\n");
        sb.append("    signatureType: ").append(this.toIndentedString((Object)this.signatureType)).append("\n");
        sb.append("    signatureId: ").append(this.toIndentedString(this.signatureId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SignatureTypeEnum {
        NONE("None"),
        TEXT("Text"),
        IMAGE("Image"),
        DIGITAL("Digital"),
        BARCODE("Barcode"),
        QRCODE("QRCode"),
        STAMP("Stamp"),
        FORMFIELD("FormField"),
        METADATA("Metadata");

        private String value;

        private SignatureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SignatureTypeEnum fromValue(String text) {
            for (SignatureTypeEnum b : SignatureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SignatureTypeEnum> {
            public void write(JsonWriter jsonWriter, SignatureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SignatureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SignatureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

