/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.PdfDigitalSignature;
import com.groupdocs.cloud.signature.model.Signature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Contains digital Signature properties")
public class DigitalSignature
extends Signature {
    @SerializedName(value="comments")
    private String comments = null;
    @SerializedName(value="isValid")
    private Boolean isValid = null;
    @SerializedName(value="signTime")
    private OffsetDateTime signTime = null;
    @SerializedName(value="pdfDigitalSignature")
    private PdfDigitalSignature pdfDigitalSignature = null;

    public DigitalSignature comments(String comments) {
        this.comments = comments;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the signing purpose comment")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public DigitalSignature isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @ApiModelProperty(required=true, value="Keeps true if this digital signature is valid and the document has not been tampered with")
    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public DigitalSignature signTime(OffsetDateTime signTime) {
        this.signTime = signTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the time the document was signed")
    public OffsetDateTime getSignTime() {
        return this.signTime;
    }

    public void setSignTime(OffsetDateTime signTime) {
        this.signTime = signTime;
    }

    public DigitalSignature pdfDigitalSignature(PdfDigitalSignature pdfDigitalSignature) {
        this.pdfDigitalSignature = pdfDigitalSignature;
        return this;
    }

    @ApiModelProperty(value="Pdf digital signature properties")
    public PdfDigitalSignature getPdfDigitalSignature() {
        return this.pdfDigitalSignature;
    }

    public void setPdfDigitalSignature(PdfDigitalSignature pdfDigitalSignature) {
        this.pdfDigitalSignature = pdfDigitalSignature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigitalSignature digitalSignature = (DigitalSignature)o;
        return Objects.equals(this.comments, digitalSignature.comments) && Objects.equals(this.isValid, digitalSignature.isValid) && Objects.equals(this.signTime, digitalSignature.signTime) && Objects.equals(this.pdfDigitalSignature, digitalSignature.pdfDigitalSignature) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.comments, this.isValid, this.signTime, this.pdfDigitalSignature, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DigitalSignature {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    signTime: ").append(this.toIndentedString(this.signTime)).append("\n");
        sb.append("    pdfDigitalSignature: ").append(this.toIndentedString(this.pdfDigitalSignature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

