/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.SignatureAppearance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Describes appearance of Signature Line for Digital Signature. One Signature Line could be applied for only one Digital Signature. Signature Line always is on the first page. This feature may be useful for .docx, .doc, .odt and .xlsx file formats.")
public class DigitalSignatureAppearance
extends SignatureAppearance {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="signer")
    private String signer = null;
    @SerializedName(value="title")
    private String title = null;

    public DigitalSignatureAppearance email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a email that will be displayed in signature line.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public DigitalSignatureAppearance signer(String signer) {
        this.signer = signer;
        return this;
    }

    @ApiModelProperty(value="Gets or sets signer name for signature line.")
    public String getSigner() {
        return this.signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public DigitalSignatureAppearance title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a title for signature line.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigitalSignatureAppearance digitalSignatureAppearance = (DigitalSignatureAppearance)o;
        return Objects.equals(this.email, digitalSignatureAppearance.email) && Objects.equals(this.signer, digitalSignatureAppearance.signer) && Objects.equals(this.title, digitalSignatureAppearance.title) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.email, this.signer, this.title, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DigitalSignatureAppearance {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    signer: ").append(this.toIndentedString(this.signer)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

