/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.SignatureAppearance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Describes extended appearance features for Image Signature.")
public class ImageAppearance
extends SignatureAppearance {
    @SerializedName(value="brightness")
    private Double brightness = null;
    @SerializedName(value="contrast")
    private Double contrast = null;
    @SerializedName(value="gammaCorrection")
    private Double gammaCorrection = null;
    @SerializedName(value="grayscale")
    private Boolean grayscale = null;

    public ImageAppearance brightness(Double brightness) {
        this.brightness = brightness;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets image brightness. Default value is 1 it corresponds to original brightness of image.")
    public Double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(Double brightness) {
        this.brightness = brightness;
    }

    public ImageAppearance contrast(Double contrast) {
        this.contrast = contrast;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets image contrast. Default value is 1 it corresponds to original contrast of image.")
    public Double getContrast() {
        return this.contrast;
    }

    public void setContrast(Double contrast) {
        this.contrast = contrast;
    }

    public ImageAppearance gammaCorrection(Double gammaCorrection) {
        this.gammaCorrection = gammaCorrection;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets image gamma. Default value is 1 it corresponds to original gamma of image.")
    public Double getGammaCorrection() {
        return this.gammaCorrection;
    }

    public void setGammaCorrection(Double gammaCorrection) {
        this.gammaCorrection = gammaCorrection;
    }

    public ImageAppearance grayscale(Boolean grayscale) {
        this.grayscale = grayscale;
        return this;
    }

    @ApiModelProperty(required=true, value="Setup this flag to true if gray-scale filter is required.")
    public Boolean getGrayscale() {
        return this.grayscale;
    }

    public void setGrayscale(Boolean grayscale) {
        this.grayscale = grayscale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageAppearance imageAppearance = (ImageAppearance)o;
        return Objects.equals(this.brightness, imageAppearance.brightness) && Objects.equals(this.contrast, imageAppearance.contrast) && Objects.equals(this.gammaCorrection, imageAppearance.gammaCorrection) && Objects.equals(this.grayscale, imageAppearance.grayscale) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.brightness, this.contrast, this.gammaCorrection, this.grayscale, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageAppearance {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    brightness: ").append(this.toIndentedString(this.brightness)).append("\n");
        sb.append("    contrast: ").append(this.toIndentedString(this.contrast)).append("\n");
        sb.append("    gammaCorrection: ").append(this.toIndentedString(this.gammaCorrection)).append("\n");
        sb.append("    grayscale: ").append(this.toIndentedString(this.grayscale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

