/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.Signature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Contains Metadata signature properties.")
public class MetadataSignature
extends Signature {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="dataType")
    private DataTypeEnum dataType = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="id")
    private Integer id = null;
    @SerializedName(value="size")
    private Integer size = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="tagPrefix")
    private String tagPrefix = null;

    public MetadataSignature type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies metadata type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MetadataSignature dataType(DataTypeEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies metadata value type.")
    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public MetadataSignature value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Specifies metadata object value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public MetadataSignature name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Specifies unique metadata name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetadataSignature id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of Image Metadata signature. See GroupDocs.Signature.Domain.ImageMetadataSignatures class that contains standard Signature with predefined Id value.")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public MetadataSignature size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Size of  Image Metadata value")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public MetadataSignature description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description for standard Image Metadata signature")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MetadataSignature tagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
        return this;
    }

    @ApiModelProperty(value="The prefix tag of Pdf Metadata signature name. By default this property is set to \"xmp\". Possible values are")
    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSignature metadataSignature = (MetadataSignature)o;
        return Objects.equals((Object)this.type, (Object)metadataSignature.type) && Objects.equals((Object)this.dataType, (Object)metadataSignature.dataType) && Objects.equals(this.value, metadataSignature.value) && Objects.equals(this.name, metadataSignature.name) && Objects.equals(this.id, metadataSignature.id) && Objects.equals(this.size, metadataSignature.size) && Objects.equals(this.description, metadataSignature.description) && Objects.equals(this.tagPrefix, metadataSignature.tagPrefix) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.dataType, this.value, this.name, this.id, this.size, this.description, this.tagPrefix, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataSignature {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString((Object)this.dataType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tagPrefix: ").append(this.toIndentedString(this.tagPrefix)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DataTypeEnum {
        UNDEFINED("Undefined"),
        BOOLEAN("Boolean"),
        INTEGER("Integer"),
        DOUBLE("Double"),
        DATETIME("DateTime"),
        STRING("String");

        private String value;

        private DataTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DataTypeEnum fromValue(String text) {
            for (DataTypeEnum b : DataTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DataTypeEnum> {
            public void write(JsonWriter jsonWriter, DataTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DataTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DataTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        NONE("None"),
        CERTIFICATE("Certificate"),
        IMAGE("Image"),
        PDF("Pdf"),
        PRESENTATION("Presentation"),
        SPREADSHEET("Spreadsheet"),
        WORDPROCESSING("WordProcessing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

