/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.PagesSetup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Base container class for all possible options data")
public class OptionsBase {
    @SerializedName(value="signatureType")
    private SignatureTypeEnum signatureType = null;
    @SerializedName(value="page")
    private Integer page = null;
    @SerializedName(value="allPages")
    private Boolean allPages = null;
    @SerializedName(value="pagesSetup")
    private PagesSetup pagesSetup = null;

    public OptionsBase signatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the signature type of processing")
    public SignatureTypeEnum getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
    }

    public OptionsBase page(Integer page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a document page number for processing. Value is optional")
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public OptionsBase allPages(Boolean allPages) {
        this.allPages = allPages;
        return this;
    }

    @ApiModelProperty(required=true, value="Process all document pages. Type of processing depends on SignatureType For Images Document Type it can be used only for multi-frames images like .tiff")
    public Boolean getAllPages() {
        return this.allPages;
    }

    public void setAllPages(Boolean allPages) {
        this.allPages = allPages;
    }

    public OptionsBase pagesSetup(PagesSetup pagesSetup) {
        this.pagesSetup = pagesSetup;
        return this;
    }

    @ApiModelProperty(value="Options to specify pages for processing")
    public PagesSetup getPagesSetup() {
        return this.pagesSetup;
    }

    public void setPagesSetup(PagesSetup pagesSetup) {
        this.pagesSetup = pagesSetup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionsBase optionsBase = (OptionsBase)o;
        return Objects.equals((Object)this.signatureType, (Object)optionsBase.signatureType) && Objects.equals(this.page, optionsBase.page) && Objects.equals(this.allPages, optionsBase.allPages) && Objects.equals(this.pagesSetup, optionsBase.pagesSetup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureType, this.page, this.allPages, this.pagesSetup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionsBase {\n");
        sb.append("    signatureType: ").append(this.toIndentedString((Object)this.signatureType)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    allPages: ").append(this.toIndentedString(this.allPages)).append("\n");
        sb.append("    pagesSetup: ").append(this.toIndentedString(this.pagesSetup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SignatureTypeEnum {
        NONE("None"),
        TEXT("Text"),
        IMAGE("Image"),
        DIGITAL("Digital"),
        BARCODE("Barcode"),
        QRCODE("QRCode"),
        STAMP("Stamp"),
        FORMFIELD("FormField"),
        METADATA("Metadata");

        private String value;

        private SignatureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SignatureTypeEnum fromValue(String text) {
            for (SignatureTypeEnum b : SignatureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SignatureTypeEnum> {
            public void write(JsonWriter jsonWriter, SignatureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SignatureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SignatureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

