/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.signature.model.TimeStamp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Contains pdf digital Signature properties")
public class PdfDigitalSignature {
    @SerializedName(value="contactInfo")
    private String contactInfo = null;
    @SerializedName(value="location")
    private String location = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="timeStamp")
    private TimeStamp timeStamp = null;
    @SerializedName(value="showProperties")
    private Boolean showProperties = null;

    public PdfDigitalSignature contactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    @ApiModelProperty(value="Information provided by the signer to enable a recipient to contact the signer")
    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    public PdfDigitalSignature location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(value="The CPU host name or physical location of the signing.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public PdfDigitalSignature reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the signing, such as (I agree\u0420\u0406\u0420\u201a\u0412\u00a6).")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public PdfDigitalSignature type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of Pdf digital signature.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PdfDigitalSignature timeStamp(TimeStamp timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    @ApiModelProperty(required=true, value="Time stamp for Pdf digital signature. Default value is null.")
    public TimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(TimeStamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    public PdfDigitalSignature showProperties(Boolean showProperties) {
        this.showProperties = showProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Force to show/hide signature properties")
    public Boolean getShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(Boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfDigitalSignature pdfDigitalSignature = (PdfDigitalSignature)o;
        return Objects.equals(this.contactInfo, pdfDigitalSignature.contactInfo) && Objects.equals(this.location, pdfDigitalSignature.location) && Objects.equals(this.reason, pdfDigitalSignature.reason) && Objects.equals((Object)this.type, (Object)pdfDigitalSignature.type) && Objects.equals(this.timeStamp, pdfDigitalSignature.timeStamp) && Objects.equals(this.showProperties, pdfDigitalSignature.showProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contactInfo, this.location, this.reason, this.type, this.timeStamp, this.showProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfDigitalSignature {\n");
        sb.append("    contactInfo: ").append(this.toIndentedString(this.contactInfo)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    timeStamp: ").append(this.toIndentedString(this.timeStamp)).append("\n");
        sb.append("    showProperties: ").append(this.toIndentedString(this.showProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SIGNATURE("Signature"),
        CERTIFICATE("Certificate");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

