/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.signature.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.signature.model.Color;
import com.groupdocs.cloud.signature.model.SignatureAppearance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Describes appearance of Digital Signature are on PDF documents.")
public class PdfDigitalSignatureAppearance
extends SignatureAppearance {
    @SerializedName(value="background")
    private Color background = null;
    @SerializedName(value="foreground")
    private Color foreground = null;
    @SerializedName(value="contactInfoLabel")
    private String contactInfoLabel = null;
    @SerializedName(value="dateSignedAtLabel")
    private String dateSignedAtLabel = null;
    @SerializedName(value="digitalSignedLabel")
    private String digitalSignedLabel = null;
    @SerializedName(value="fontFamilyName")
    private String fontFamilyName = null;
    @SerializedName(value="fontSize")
    private Double fontSize = null;
    @SerializedName(value="locationLabel")
    private String locationLabel = null;
    @SerializedName(value="reasonLabel")
    private String reasonLabel = null;

    public PdfDigitalSignatureAppearance background(Color background) {
        this.background = background;
        return this;
    }

    @ApiModelProperty(value="Get or set background color of signature appearance. ")
    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public PdfDigitalSignatureAppearance foreground(Color foreground) {
        this.foreground = foreground;
        return this;
    }

    @ApiModelProperty(value="Get or set foreground text color of signature appearance. By default the value is Color.FromArgb(76, 100, 255)")
    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public PdfDigitalSignatureAppearance contactInfoLabel(String contactInfoLabel) {
        this.contactInfoLabel = contactInfoLabel;
        return this;
    }

    @ApiModelProperty(value="Gets or sets contact info label. Default value: \"Contact\". if this value is empty then no contact label will appear on digital signature area.             ")
    public String getContactInfoLabel() {
        return this.contactInfoLabel;
    }

    public void setContactInfoLabel(String contactInfoLabel) {
        this.contactInfoLabel = contactInfoLabel;
    }

    public PdfDigitalSignatureAppearance dateSignedAtLabel(String dateSignedAtLabel) {
        this.dateSignedAtLabel = dateSignedAtLabel;
        return this;
    }

    @ApiModelProperty(value="Gets or sets date signed label. Default value: \"Date\".")
    public String getDateSignedAtLabel() {
        return this.dateSignedAtLabel;
    }

    public void setDateSignedAtLabel(String dateSignedAtLabel) {
        this.dateSignedAtLabel = dateSignedAtLabel;
    }

    public PdfDigitalSignatureAppearance digitalSignedLabel(String digitalSignedLabel) {
        this.digitalSignedLabel = digitalSignedLabel;
        return this;
    }

    @ApiModelProperty(value="Gets or sets digital signed label. Default value: \"Digitally signed by\".")
    public String getDigitalSignedLabel() {
        return this.digitalSignedLabel;
    }

    public void setDigitalSignedLabel(String digitalSignedLabel) {
        this.digitalSignedLabel = digitalSignedLabel;
    }

    public PdfDigitalSignatureAppearance fontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the Font family name to display the labels. Default value is \"Arial\".")
    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public PdfDigitalSignatureAppearance fontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the Font size to display the labels. Default value is 10.")
    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public PdfDigitalSignatureAppearance locationLabel(String locationLabel) {
        this.locationLabel = locationLabel;
        return this;
    }

    @ApiModelProperty(value="Gets or sets location label. Default value: \"Location\". if this value is empty then no location label will appear on digital signature area.")
    public String getLocationLabel() {
        return this.locationLabel;
    }

    public void setLocationLabel(String locationLabel) {
        this.locationLabel = locationLabel;
    }

    public PdfDigitalSignatureAppearance reasonLabel(String reasonLabel) {
        this.reasonLabel = reasonLabel;
        return this;
    }

    @ApiModelProperty(value="Gets or sets reason label. Default value: \"Reason\". if this value is empty then no reason label will appear on digital signature area.")
    public String getReasonLabel() {
        return this.reasonLabel;
    }

    public void setReasonLabel(String reasonLabel) {
        this.reasonLabel = reasonLabel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfDigitalSignatureAppearance pdfDigitalSignatureAppearance = (PdfDigitalSignatureAppearance)o;
        return Objects.equals(this.background, pdfDigitalSignatureAppearance.background) && Objects.equals(this.foreground, pdfDigitalSignatureAppearance.foreground) && Objects.equals(this.contactInfoLabel, pdfDigitalSignatureAppearance.contactInfoLabel) && Objects.equals(this.dateSignedAtLabel, pdfDigitalSignatureAppearance.dateSignedAtLabel) && Objects.equals(this.digitalSignedLabel, pdfDigitalSignatureAppearance.digitalSignedLabel) && Objects.equals(this.fontFamilyName, pdfDigitalSignatureAppearance.fontFamilyName) && Objects.equals(this.fontSize, pdfDigitalSignatureAppearance.fontSize) && Objects.equals(this.locationLabel, pdfDigitalSignatureAppearance.locationLabel) && Objects.equals(this.reasonLabel, pdfDigitalSignatureAppearance.reasonLabel) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.background, this.foreground, this.contactInfoLabel, this.dateSignedAtLabel, this.digitalSignedLabel, this.fontFamilyName, this.fontSize, this.locationLabel, this.reasonLabel, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfDigitalSignatureAppearance {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    background: ").append(this.toIndentedString(this.background)).append("\n");
        sb.append("    foreground: ").append(this.toIndentedString(this.foreground)).append("\n");
        sb.append("    contactInfoLabel: ").append(this.toIndentedString(this.contactInfoLabel)).append("\n");
        sb.append("    dateSignedAtLabel: ").append(this.toIndentedString(this.dateSignedAtLabel)).append("\n");
        sb.append("    digitalSignedLabel: ").append(this.toIndentedString(this.digitalSignedLabel)).append("\n");
        sb.append("    fontFamilyName: ").append(this.toIndentedString(this.fontFamilyName)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    locationLabel: ").append(this.toIndentedString(this.locationLabel)).append("\n");
        sb.append("    reasonLabel: ").append(this.toIndentedString(this.reasonLabel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

